/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.grpc.stub.ClientCallStreamObserver;
import java.util.concurrent.atomic.AtomicBoolean;

public class SynchronizedRequestStream<T>
extends ClientCallStreamObserver<T> {
    private final ClientCallStreamObserver<T> delegate;
    private final AtomicBoolean lock = new AtomicBoolean(false);
    private final AtomicBoolean halfClosed = new AtomicBoolean(false);

    public SynchronizedRequestStream(ClientCallStreamObserver<T> requestStream) {
        this.delegate = requestStream;
    }

    public void cancel(String message, Throwable cause) {
        this.halfClosed.set(true);
        this.delegate.cancel(message, cause);
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        this.delegate.setOnReadyHandler(onReadyHandler);
    }

    public void disableAutoInboundFlowControl() {
        this.delegate.disableAutoInboundFlowControl();
    }

    public void request(int count) {
        this.delegate.request(count);
    }

    public void setMessageCompression(boolean enable) {
        this.delegate.setMessageCompression(enable);
    }

    public void onNext(T value) {
        this.inLock(() -> this.delegate.onNext(value));
    }

    public void onError(Throwable t) {
        this.inLock(() -> {
            this.delegate.onError(t);
            this.halfClosed.set(true);
        });
    }

    public void onCompleted() {
        this.inLock(() -> {
            this.delegate.onCompleted();
            this.halfClosed.set(true);
        });
    }

    private void inLock(Runnable action) {
        while (!this.lock.compareAndSet(false, true)) {
            Thread.yield();
        }
        try {
            if (!this.halfClosed.get()) {
                action.run();
            }
        }
        finally {
            this.lock.set(false);
        }
    }
}

