/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.impl.AxonServerManagedChannel;
import io.grpc.ConnectivityState;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAxonServerChannel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAxonServerChannel.class);
    private final ScheduledExecutorService executor;
    private final AxonServerManagedChannel channel;

    public AbstractAxonServerChannel(ScheduledExecutorService executor, AxonServerManagedChannel axonServerManagedChannel) {
        this.executor = executor;
        this.channel = axonServerManagedChannel;
    }

    protected void scheduleReconnect() {
        this.scheduleReconnect(false);
    }

    protected void scheduleImmediateReconnect() {
        logger.debug("Scheduling immediate reconnect");
        this.scheduleReconnect(true);
    }

    private void scheduleReconnect(boolean immediate) {
        this.executor.schedule(() -> {
            ConnectivityState connectivityState = this.channel.getState(immediate);
            if (connectivityState == ConnectivityState.READY) {
                this.connect();
            } else {
                logger.debug("No connection to AxonServer available. Scheduling next attempt in 500ms");
                this.scheduleReconnect(false);
            }
        }, immediate ? 0L : 500L, TimeUnit.MILLISECONDS);
    }

    public abstract void connect();

    public abstract void reconnect();

    public abstract void disconnect();

    public abstract boolean isConnected();
}

