/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.testcontainers;

import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.core.region.StaticRegionProvider;
import io.awspring.cloud.testcontainers.AwsClientFactory;
import org.testcontainers.localstack.LocalStackContainer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

public class LocalstackAwsClientFactory
implements AwsClientFactory {
    private final AwsClientBuilderConfigurer configurer;

    public LocalstackAwsClientFactory(LocalStackContainer localstack) {
        this.configurer = this.clientBuilderConfigurer(localstack);
    }

    @Override
    public <CLIENT, BUILDER extends AwsClientBuilder<BUILDER, CLIENT>> CLIENT create(BUILDER builder) {
        return (CLIENT)this.configurer.configure(builder).build();
    }

    private AwsClientBuilderConfigurer clientBuilderConfigurer(LocalStackContainer localstack) {
        AwsProperties properties = new AwsProperties();
        properties.setEndpoint(localstack.getEndpoint());
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey()));
        StaticRegionProvider regionProvider = new StaticRegionProvider(localstack.getRegion());
        return new AwsClientBuilderConfigurer((AwsCredentialsProvider)credentialsProvider, (AwsRegionProvider)regionProvider, properties);
    }
}

