/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.Visibility;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public class QueueMessageVisibility
implements Visibility {
    private static final Logger logger = LoggerFactory.getLogger(QueueMessageVisibility.class);
    private final SqsAsyncClient sqsAsyncClient;
    private final String queueUrl;
    private final String receiptHandle;

    public QueueMessageVisibility(SqsAsyncClient amazonSqsAsync, String queueUrl, String receiptHandle) {
        this.sqsAsyncClient = amazonSqsAsync;
        this.queueUrl = queueUrl;
        this.receiptHandle = receiptHandle;
    }

    @Override
    public CompletableFuture<Void> changeToAsync(int seconds) {
        return this.sqsAsyncClient.changeMessageVisibility(req -> req.queueUrl(this.queueUrl).receiptHandle(this.receiptHandle).visibilityTimeout(Integer.valueOf(seconds))).thenRun(() -> logger.trace("Changed the visibility of message {} to {} seconds", (Object)this.receiptHandle, (Object)seconds));
    }
}

