/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretsManagerPropertySource
extends EnumerablePropertySource<SecretsManagerClient> {
    private static Log LOG = LogFactory.getLog(SecretsManagerPropertySource.class);
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final String context;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public SecretsManagerPropertySource(String context, SecretsManagerClient smClient) {
        super(context, (Object)smClient);
        this.context = context;
    }

    public void init() {
        this.readSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.context).build());
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void readSecretValue(GetSecretValueRequest secretValueRequest) {
        GetSecretValueResponse secretValueResponse = ((SecretsManagerClient)this.source).getSecretValue(secretValueRequest);
        try {
            Map secretMap = (Map)this.jsonMapper.readValue(secretValueResponse.secretString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (Map.Entry secretEntry : secretMap.entrySet()) {
                LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + (String)secretEntry.getKey()));
                this.properties.put((String)secretEntry.getKey(), secretEntry.getValue());
            }
        }
        catch (JsonParseException e) {
            String[] parts = secretValueResponse.name().split("/");
            String secretName = parts[parts.length - 1];
            LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretName));
            this.properties.put(secretName, secretValueResponse.secretString());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

