/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.lang.Nullable;

public class AwsSecretsManagerPropertySource
extends EnumerablePropertySource<AWSSecretsManager> {
    private static Log LOG = LogFactory.getLog(AwsSecretsManagerPropertySource.class);
    private static final String PREFIX_PART = "?prefix=";
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final String secretId;
    @Nullable
    private final String prefix;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public AwsSecretsManagerPropertySource(String context, AWSSecretsManager smClient) {
        super(context, (Object)smClient);
        this.secretId = AwsSecretsManagerPropertySource.resolveSecretId(context);
        this.prefix = AwsSecretsManagerPropertySource.resolvePrefix(context);
    }

    public void init() {
        this.readSecretValue(new GetSecretValueRequest().withSecretId(this.secretId));
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void readSecretValue(GetSecretValueRequest secretValueRequest) {
        GetSecretValueResult secretValueResult = ((AWSSecretsManager)this.source).getSecretValue(secretValueRequest);
        try {
            Map secretMap = (Map)this.jsonMapper.readValue(secretValueResult.getSecretString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (Map.Entry secretEntry : secretMap.entrySet()) {
                LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + (String)secretEntry.getKey()));
                String propertyKey = this.prefix != null ? this.prefix + (String)secretEntry.getKey() : (String)secretEntry.getKey();
                this.properties.put(propertyKey, secretEntry.getValue());
            }
        }
        catch (JsonParseException e) {
            String[] parts = secretValueResult.getName().split("/");
            String secretName = parts[parts.length - 1];
            LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretName));
            String propertyKey = this.prefix != null ? this.prefix + secretName : secretName;
            this.properties.put(propertyKey, secretValueResult.getSecretString());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static String resolvePrefix(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(prefixIndex + PREFIX_PART.length());
        }
        return null;
    }

    private static String resolveSecretId(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(0, prefixIndex);
        }
        return context;
    }
}

