/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3.model.ObjectLockMode;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class ObjectMetadata {
    @Nullable
    private final String acl;
    @Nullable
    private final String cacheControl;
    @Nullable
    private final String contentDisposition;
    @Nullable
    private final String contentEncoding;
    @Nullable
    private final String contentLanguage;
    @Nullable
    private final Long contentLength;
    @Nullable
    private final String contentType;
    @Nullable
    private final Instant expires;
    @Nullable
    private final String grantFullControl;
    @Nullable
    private final String grantRead;
    @Nullable
    private final String grantReadACP;
    @Nullable
    private final String grantWriteACP;
    @Nullable
    private final Map<String, String> metadata;
    @Nullable
    private final String serverSideEncryption;
    @Nullable
    private final String storageClass;
    @Nullable
    private final String websiteRedirectLocation;
    @Nullable
    private final String sseCustomerAlgorithm;
    @Nullable
    private final String sseCustomerKey;
    @Nullable
    private final String sseCustomerKeyMD5;
    @Nullable
    private final String ssekmsKeyId;
    @Nullable
    private final String ssekmsEncryptionContext;
    @Nullable
    private final Boolean bucketKeyEnabled;
    @Nullable
    private final String requestPayer;
    @Nullable
    private final String tagging;
    @Nullable
    private final String objectLockMode;
    @Nullable
    private final Instant objectLockRetainUntilDate;
    @Nullable
    private final String objectLockLegalHoldStatus;
    @Nullable
    private final String expectedBucketOwner;
    @Nullable
    private final String checksumAlgorithm;

    public static Builder builder() {
        return new Builder();
    }

    ObjectMetadata(@Nullable String acl, @Nullable String cacheControl, @Nullable String contentDisposition, @Nullable String contentEncoding, @Nullable String contentLanguage, @Nullable String contentType, @Nullable Long contentLength, @Nullable Instant expires, @Nullable String grantFullControl, @Nullable String grantRead, @Nullable String grantReadACP, @Nullable String grantWriteACP, @Nullable Map<String, String> metadata, @Nullable String serverSideEncryption, @Nullable String storageClass, @Nullable String websiteRedirectLocation, @Nullable String sseCustomerAlgorithm, @Nullable String sseCustomerKey, @Nullable String sseCustomerKeyMD5, @Nullable String ssekmsKeyId, @Nullable String ssekmsEncryptionContext, @Nullable Boolean bucketKeyEnabled, @Nullable String requestPayer, @Nullable String tagging, @Nullable String objectLockMode, @Nullable Instant objectLockRetainUntilDate, @Nullable String objectLockLegalHoldStatus, @Nullable String expectedBucketOwner, @Nullable String checksumAlgorithm) {
        this.acl = acl;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
        this.contentEncoding = contentEncoding;
        this.contentLanguage = contentLanguage;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.expires = expires;
        this.grantFullControl = grantFullControl;
        this.grantRead = grantRead;
        this.grantReadACP = grantReadACP;
        this.grantWriteACP = grantWriteACP;
        this.metadata = metadata;
        this.serverSideEncryption = serverSideEncryption;
        this.storageClass = storageClass;
        this.websiteRedirectLocation = websiteRedirectLocation;
        this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        this.sseCustomerKey = sseCustomerKey;
        this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        this.ssekmsKeyId = ssekmsKeyId;
        this.ssekmsEncryptionContext = ssekmsEncryptionContext;
        this.bucketKeyEnabled = bucketKeyEnabled;
        this.requestPayer = requestPayer;
        this.tagging = tagging;
        this.objectLockMode = objectLockMode;
        this.objectLockRetainUntilDate = objectLockRetainUntilDate;
        this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
        this.expectedBucketOwner = expectedBucketOwner;
        this.checksumAlgorithm = checksumAlgorithm;
    }

    void apply(PutObjectRequest.Builder builder) {
        if (this.acl != null) {
            builder.acl(this.acl);
        }
        if (this.cacheControl != null) {
            builder.cacheControl(this.cacheControl);
        }
        if (this.contentDisposition != null) {
            builder.contentDisposition(this.contentDisposition);
        }
        if (this.contentEncoding != null) {
            builder.contentEncoding(this.contentEncoding);
        }
        if (this.contentLanguage != null) {
            builder.contentLanguage(this.contentLanguage);
        }
        if (this.contentType != null) {
            builder.contentType(this.contentType);
        }
        if (this.contentLength != null) {
            builder.contentLength(this.contentLength);
        }
        if (this.expires != null) {
            builder.expires(this.expires);
        }
        if (this.grantFullControl != null) {
            builder.grantFullControl(this.grantFullControl);
        }
        if (this.grantRead != null) {
            builder.grantRead(this.grantRead);
        }
        if (this.grantReadACP != null) {
            builder.grantReadACP(this.grantReadACP);
        }
        if (this.grantWriteACP != null) {
            builder.grantWriteACP(this.grantWriteACP);
        }
        if (this.metadata != null) {
            builder.metadata(this.metadata);
        }
        if (this.serverSideEncryption != null) {
            builder.serverSideEncryption(this.serverSideEncryption);
        }
        if (this.storageClass != null) {
            builder.storageClass(this.storageClass);
        }
        if (this.websiteRedirectLocation != null) {
            builder.websiteRedirectLocation(this.websiteRedirectLocation);
        }
        if (this.sseCustomerAlgorithm != null) {
            builder.sseCustomerAlgorithm(this.sseCustomerAlgorithm);
        }
        if (this.sseCustomerKey != null) {
            builder.sseCustomerKey(this.sseCustomerKey);
        }
        if (this.sseCustomerKeyMD5 != null) {
            builder.sseCustomerKeyMD5(this.sseCustomerKeyMD5);
        }
        if (this.ssekmsKeyId != null) {
            builder.ssekmsKeyId(this.ssekmsKeyId);
        }
        if (this.ssekmsEncryptionContext != null) {
            builder.ssekmsEncryptionContext(this.ssekmsEncryptionContext);
        }
        if (this.bucketKeyEnabled != null) {
            builder.bucketKeyEnabled(this.bucketKeyEnabled);
        }
        if (this.requestPayer != null) {
            builder.requestPayer(this.requestPayer);
        }
        if (this.tagging != null) {
            builder.tagging(this.tagging);
        }
        if (this.objectLockMode != null) {
            builder.objectLockMode(this.objectLockMode);
        }
        if (this.objectLockRetainUntilDate != null) {
            builder.objectLockRetainUntilDate(this.objectLockRetainUntilDate);
        }
        if (this.objectLockLegalHoldStatus != null) {
            builder.objectLockLegalHoldStatus(this.objectLockLegalHoldStatus);
        }
        if (this.expectedBucketOwner != null) {
            builder.expectedBucketOwner(this.expectedBucketOwner);
        }
        if (this.checksumAlgorithm != null) {
            builder.checksumAlgorithm(this.checksumAlgorithm);
        }
    }

    void apply(CreateMultipartUploadRequest.Builder builder) {
        if (this.acl != null) {
            builder.acl(this.acl);
        }
        if (this.cacheControl != null) {
            builder.cacheControl(this.cacheControl);
        }
        if (this.contentDisposition != null) {
            builder.contentDisposition(this.contentDisposition);
        }
        if (this.contentEncoding != null) {
            builder.contentEncoding(this.contentEncoding);
        }
        if (this.contentLanguage != null) {
            builder.contentLanguage(this.contentLanguage);
        }
        if (this.contentType != null) {
            builder.contentType(this.contentType);
        }
        if (this.expires != null) {
            builder.expires(this.expires);
        }
        if (this.grantFullControl != null) {
            builder.grantFullControl(this.grantFullControl);
        }
        if (this.grantRead != null) {
            builder.grantRead(this.grantRead);
        }
        if (this.grantReadACP != null) {
            builder.grantReadACP(this.grantReadACP);
        }
        if (this.grantWriteACP != null) {
            builder.grantWriteACP(this.grantWriteACP);
        }
        if (this.metadata != null) {
            builder.metadata(this.metadata);
        }
        if (this.serverSideEncryption != null) {
            builder.serverSideEncryption(this.serverSideEncryption);
        }
        if (this.storageClass != null) {
            builder.storageClass(this.storageClass);
        }
        if (this.websiteRedirectLocation != null) {
            builder.websiteRedirectLocation(this.websiteRedirectLocation);
        }
        if (this.sseCustomerAlgorithm != null) {
            builder.sseCustomerAlgorithm(this.sseCustomerAlgorithm);
        }
        if (this.sseCustomerKey != null) {
            builder.sseCustomerKey(this.sseCustomerKey);
        }
        if (this.sseCustomerKeyMD5 != null) {
            builder.sseCustomerKeyMD5(this.sseCustomerKeyMD5);
        }
        if (this.ssekmsKeyId != null) {
            builder.ssekmsKeyId(this.ssekmsKeyId);
        }
        if (this.ssekmsEncryptionContext != null) {
            builder.ssekmsEncryptionContext(this.ssekmsEncryptionContext);
        }
        if (this.bucketKeyEnabled != null) {
            builder.bucketKeyEnabled(this.bucketKeyEnabled);
        }
        if (this.requestPayer != null) {
            builder.requestPayer(this.requestPayer);
        }
        if (this.tagging != null) {
            builder.tagging(this.tagging);
        }
        if (this.objectLockMode != null) {
            builder.objectLockMode(this.objectLockMode);
        }
        if (this.objectLockRetainUntilDate != null) {
            builder.objectLockRetainUntilDate(this.objectLockRetainUntilDate);
        }
        if (this.objectLockLegalHoldStatus != null) {
            builder.objectLockLegalHoldStatus(this.objectLockLegalHoldStatus);
        }
        if (this.expectedBucketOwner != null) {
            builder.expectedBucketOwner(this.expectedBucketOwner);
        }
        if (this.checksumAlgorithm != null) {
            builder.checksumAlgorithm(this.checksumAlgorithm);
        }
    }

    void apply(UploadPartRequest.Builder builder) {
        if (this.sseCustomerAlgorithm != null) {
            builder.sseCustomerAlgorithm(this.sseCustomerAlgorithm);
        }
        if (this.sseCustomerKey != null) {
            builder.sseCustomerKey(this.sseCustomerKey);
        }
        if (this.sseCustomerKeyMD5 != null) {
            builder.sseCustomerKeyMD5(this.sseCustomerKeyMD5);
        }
        if (this.requestPayer != null) {
            builder.requestPayer(this.requestPayer);
        }
        if (this.expectedBucketOwner != null) {
            builder.expectedBucketOwner(this.expectedBucketOwner);
        }
        if (this.checksumAlgorithm != null) {
            builder.checksumAlgorithm(this.checksumAlgorithm);
        }
    }

    void apply(CompleteMultipartUploadRequest.Builder builder) {
        if (this.sseCustomerAlgorithm != null) {
            builder.sseCustomerAlgorithm(this.sseCustomerAlgorithm);
        }
        if (this.sseCustomerKey != null) {
            builder.sseCustomerKey(this.sseCustomerKey);
        }
        if (this.sseCustomerKeyMD5 != null) {
            builder.sseCustomerKeyMD5(this.sseCustomerKeyMD5);
        }
        if (this.requestPayer != null) {
            builder.requestPayer(this.requestPayer);
        }
        if (this.expectedBucketOwner != null) {
            builder.expectedBucketOwner(this.expectedBucketOwner);
        }
    }

    @Nullable
    public String getAcl() {
        return this.acl;
    }

    @Nullable
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Nullable
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @Nullable
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Nullable
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public Long getContentLength() {
        return this.contentLength;
    }

    @Nullable
    public Instant getExpires() {
        return this.expires;
    }

    @Nullable
    public String getGrantFullControl() {
        return this.grantFullControl;
    }

    @Nullable
    public String getGrantRead() {
        return this.grantRead;
    }

    @Nullable
    public String getGrantReadACP() {
        return this.grantReadACP;
    }

    @Nullable
    public String getGrantWriteACP() {
        return this.grantWriteACP;
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    @Nullable
    public String getStorageClass() {
        return this.storageClass;
    }

    @Nullable
    public String getWebsiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    @Nullable
    public String getSseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    @Nullable
    public String getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    @Nullable
    public String getSseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    @Nullable
    public String getSsekmsKeyId() {
        return this.ssekmsKeyId;
    }

    @Nullable
    public String getSsekmsEncryptionContext() {
        return this.ssekmsEncryptionContext;
    }

    @Nullable
    public Boolean getBucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    @Nullable
    public String getRequestPayer() {
        return this.requestPayer;
    }

    @Nullable
    public String getTagging() {
        return this.tagging;
    }

    @Nullable
    public String getObjectLockMode() {
        return this.objectLockMode;
    }

    @Nullable
    public Instant getObjectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    @Nullable
    public String getObjectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    @Nullable
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Nullable
    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public static class Builder {
        private final Map<String, String> metadata = new HashMap<String, String>();
        @Nullable
        private String acl;
        @Nullable
        private String cacheControl;
        @Nullable
        private String contentDisposition;
        @Nullable
        private String contentEncoding;
        @Nullable
        private String contentLanguage;
        @Nullable
        private String contentType;
        @Nullable
        private Long contentLength;
        @Nullable
        private Instant expires;
        @Nullable
        private String grantFullControl;
        @Nullable
        private String grantRead;
        @Nullable
        private String grantReadACP;
        @Nullable
        private String grantWriteACP;
        @Nullable
        private String serverSideEncryption;
        @Nullable
        private String storageClass;
        @Nullable
        private String websiteRedirectLocation;
        @Nullable
        private String sseCustomerAlgorithm;
        @Nullable
        private String sseCustomerKey;
        @Nullable
        private String sseCustomerKeyMD5;
        @Nullable
        private String ssekmsKeyId;
        @Nullable
        private String ssekmsEncryptionContext;
        @Nullable
        private Boolean bucketKeyEnabled;
        @Nullable
        private String requestPayer;
        @Nullable
        private String tagging;
        @Nullable
        private String objectLockMode;
        @Nullable
        private Instant objectLockRetainUntilDate;
        @Nullable
        private String objectLockLegalHoldStatus;
        @Nullable
        private String expectedBucketOwner;
        @Nullable
        private String checksumAlgorithm;

        public Builder acl(@Nullable String acl) {
            this.acl = acl;
            return this;
        }

        public Builder acl(@Nullable ObjectCannedACL acl) {
            return this.acl(acl != null ? acl.toString() : null);
        }

        public Builder cacheControl(@Nullable String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(@Nullable String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(@Nullable String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLanguage(@Nullable String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentType(@Nullable String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLength(@Nullable Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public Builder grantFullControl(@Nullable String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public Builder grantRead(@Nullable String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public Builder grantReadACP(@Nullable String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public Builder grantWriteACP(@Nullable String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public Builder metadata(@Nullable String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder serverSideEncryption(@Nullable String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder serverSideEncryption(@Nullable ServerSideEncryption serverSideEncryption) {
            return this.serverSideEncryption(serverSideEncryption != null ? serverSideEncryption.toString() : null);
        }

        public Builder storageClass(@Nullable String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder storageClass(@Nullable StorageClass storageClass) {
            return this.storageClass(storageClass != null ? storageClass.toString() : null);
        }

        public Builder websiteRedirectLocation(@Nullable String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public Builder sseCustomerAlgorithm(@Nullable String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public Builder sseCustomerKey(@Nullable String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public Builder sseCustomerKeyMD5(@Nullable String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public Builder ssekmsKeyId(@Nullable String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public Builder ssekmsEncryptionContext(@Nullable String ssekmsEncryptionContext) {
            this.ssekmsEncryptionContext = ssekmsEncryptionContext;
            return this;
        }

        public Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        public Builder requestPayer(@Nullable String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        public Builder requestPayer(@Nullable RequestPayer requestPayer) {
            return this.requestPayer(requestPayer != null ? requestPayer.toString() : null);
        }

        public Builder tagging(@Nullable String tagging) {
            this.tagging = tagging;
            return this;
        }

        public Builder objectLockMode(@Nullable String objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        public Builder objectLockMode(@Nullable ObjectLockMode objectLockMode) {
            return this.objectLockMode(objectLockMode != null ? objectLockMode.toString() : null);
        }

        public Builder objectLockRetainUntilDate(@Nullable Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        public Builder objectLockLegalHoldStatus(@Nullable String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
            return this;
        }

        public Builder objectLockLegalHoldStatus(@Nullable ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
            return this.objectLockLegalHoldStatus(objectLockLegalHoldStatus != null ? objectLockLegalHoldStatus.toString() : null);
        }

        public Builder expectedBucketOwner(@Nullable String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public Builder checksumAlgorithm(@Nullable String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        public Builder checksumAlgorithm(@Nullable ChecksumAlgorithm checksumAlgorithm) {
            return this.checksumAlgorithm(checksumAlgorithm != null ? checksumAlgorithm.toString() : null);
        }

        public ObjectMetadata build() {
            return new ObjectMetadata(this.acl, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, this.contentLength, this.expires, this.grantFullControl, this.grantRead, this.grantReadACP, this.grantWriteACP, this.metadata, this.serverSideEncryption, this.storageClass, this.websiteRedirectLocation, this.sseCustomerAlgorithm, this.sseCustomerKey, this.sseCustomerKeyMD5, this.ssekmsKeyId, this.ssekmsEncryptionContext, this.bucketKeyEnabled, this.requestPayer, this.tagging, this.objectLockMode, this.objectLockRetainUntilDate, this.objectLockLegalHoldStatus, this.expectedBucketOwner, this.checksumAlgorithm);
        }
    }
}

