/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.awspring.cloud.paramstore.AwsParamStoreProperties;
import io.awspring.cloud.paramstore.AwsParamStorePropertySource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.util.StringUtils;

public class AwsParamStorePropertySources {
    private final AwsParamStoreProperties properties;
    private final Log log;

    public AwsParamStorePropertySources(AwsParamStoreProperties properties, Log log) {
        this.properties = properties;
        this.log = log;
    }

    public List<String> getAutomaticContexts(List<String> profiles) {
        ArrayList<String> contexts = new ArrayList<String>();
        String prefix = this.properties.getPrefix();
        String defaultContext = this.getContext(prefix, this.properties.getDefaultContext());
        String appName = this.properties.getName();
        String appContext = prefix + "/" + appName;
        this.addProfiles(contexts, appContext, profiles);
        contexts.add(appContext + "/");
        this.addProfiles(contexts, defaultContext, profiles);
        contexts.add(defaultContext + "/");
        return contexts;
    }

    protected String getContext(String prefix, String context) {
        if (StringUtils.hasLength((String)prefix)) {
            return prefix + "/" + context;
        }
        return context;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile + "/");
        }
    }

    public AwsParamStorePropertySource createPropertySource(String context, boolean optional, AWSSimpleSystemsManagement client) {
        this.log.info((Object)("Loading property from AWS Parameter Store with name: " + context + ", optional: " + optional));
        try {
            AwsParamStorePropertySource propertySource = new AwsParamStorePropertySource(context, client);
            propertySource.init();
            return propertySource;
        }
        catch (Exception e) {
            if (!optional) {
                throw new AwsParameterPropertySourceNotFoundException(e);
            }
            this.log.warn((Object)("Unable to load AWS parameter from " + context + ". " + e.getMessage()));
            return null;
        }
    }

    static class AwsParameterPropertySourceNotFoundException
    extends RuntimeException {
        AwsParameterPropertySourceNotFoundException(Exception source) {
            super(source);
        }
    }
}

