/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParametersByPathResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;

public class AwsParamStorePropertySource
extends EnumerablePropertySource<AWSSimpleSystemsManagement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsParamStorePropertySource.class);
    private final String context;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public AwsParamStorePropertySource(String context, AWSSimpleSystemsManagement ssmClient) {
        super(context, (Object)ssmClient);
        this.context = context;
    }

    public void init() {
        GetParametersByPathRequest paramsRequest = new GetParametersByPathRequest().withPath(this.context).withRecursive(Boolean.valueOf(true)).withWithDecryption(Boolean.valueOf(true));
        this.getParameters(paramsRequest);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void getParameters(GetParametersByPathRequest paramsRequest) {
        GetParametersByPathResult paramsResult = ((AWSSimpleSystemsManagement)this.source).getParametersByPath(paramsRequest);
        for (Parameter parameter : paramsResult.getParameters()) {
            String key = parameter.getName().replace(this.context, "").replace('/', '.');
            LOGGER.debug("Populating property retrieved from AWS Parameter Store: {}", (Object)key);
            this.properties.put(key, parameter.getValue());
        }
        if (paramsResult.getNextToken() != null) {
            this.getParameters(paramsRequest.withNextToken(paramsResult.getNextToken()));
        }
    }
}

