/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.core;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import io.awspring.cloud.messaging.core.SqsMessageHeaders;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public final class QueueMessageUtils {
    private static final String RECEIPT_HANDLE_MESSAGE_ATTRIBUTE_NAME = "ReceiptHandle";
    private static final String MESSAGE_ID_MESSAGE_ATTRIBUTE_NAME = "MessageId";
    private static final String SOURCE_DATA_HEADER = "sourceData";

    private QueueMessageUtils() {
    }

    public static org.springframework.messaging.Message<String> createMessage(Message message) {
        return QueueMessageUtils.createMessage(message, Collections.emptyMap());
    }

    public static org.springframework.messaging.Message<String> createMessage(Message message, Map<String, Object> additionalHeaders) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        messageHeaders.put(MESSAGE_ID_MESSAGE_ATTRIBUTE_NAME, message.getMessageId());
        messageHeaders.put(RECEIPT_HANDLE_MESSAGE_ATTRIBUTE_NAME, message.getReceiptHandle());
        messageHeaders.put(SOURCE_DATA_HEADER, message);
        messageHeaders.putAll(additionalHeaders);
        messageHeaders.putAll(QueueMessageUtils.getAttributesAsMessageHeaders(message));
        messageHeaders.putAll(QueueMessageUtils.getMessageAttributesAsMessageHeaders(message));
        return new GenericMessage((Object)message.getBody(), (MessageHeaders)new SqsMessageHeaders(messageHeaders));
    }

    public static Object getNumberValue(String attributeValue, String attributeType) {
        try {
            return NumberParser.parseNumber(attributeValue, attributeType);
        }
        catch (ClassNotFoundException e) {
            throw new MessagingException(String.format("Message attribute with value '%s' and data type '%s' could not be converted into a Number because target class was not found.", attributeValue, attributeType), (Throwable)e);
        }
    }

    public static Message getSourceData(org.springframework.messaging.Message<?> message) {
        return (Message)message.getHeaders().get((Object)SOURCE_DATA_HEADER);
    }

    private static Map<String, Object> getAttributesAsMessageHeaders(Message message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        for (Map.Entry attributeKeyValuePair : message.getAttributes().entrySet()) {
            messageHeaders.put((String)attributeKeyValuePair.getKey(), attributeKeyValuePair.getValue());
        }
        return messageHeaders;
    }

    private static Map<String, Object> getMessageAttributesAsMessageHeaders(Message message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        for (Map.Entry messageAttribute : message.getMessageAttributes().entrySet()) {
            if ("contentType".equals(messageAttribute.getKey())) {
                messageHeaders.put("contentType", MimeType.valueOf((String)((MessageAttributeValue)messageAttribute.getValue()).getStringValue()));
                continue;
            }
            if ("id".equals(messageAttribute.getKey())) {
                messageHeaders.put("id", UUID.fromString(((MessageAttributeValue)messageAttribute.getValue()).getStringValue()));
                continue;
            }
            if (((MessageAttributeValue)messageAttribute.getValue()).getDataType().startsWith("String")) {
                messageHeaders.put((String)messageAttribute.getKey(), ((MessageAttributeValue)messageAttribute.getValue()).getStringValue());
                continue;
            }
            if (((MessageAttributeValue)messageAttribute.getValue()).getDataType().startsWith("Number")) {
                messageHeaders.put((String)messageAttribute.getKey(), QueueMessageUtils.getNumberValue((MessageAttributeValue)messageAttribute.getValue()));
                continue;
            }
            if (!((MessageAttributeValue)messageAttribute.getValue()).getDataType().startsWith("Binary")) continue;
            messageHeaders.put((String)messageAttribute.getKey(), ((MessageAttributeValue)messageAttribute.getValue()).getBinaryValue());
        }
        return messageHeaders;
    }

    private static Object getNumberValue(MessageAttributeValue value) {
        return QueueMessageUtils.getNumberValue(value.getStringValue(), value.getDataType());
    }

    private static class NumberParser {
        private static final Map<String, Class<? extends Number>> PRIMITIVE_TO_WRAPPED = new HashMap<String, Class<? extends Number>>();

        private NumberParser() {
        }

        public static Object parseNumber(String value, String type) throws ClassNotFoundException {
            if ("Number".equals(type)) {
                return NumberUtils.parseNumber((String)value, Number.class);
            }
            String javaType = type.substring("Number".length() + 1);
            if (PRIMITIVE_TO_WRAPPED.containsKey(javaType.toLowerCase())) {
                return NumberUtils.parseNumber((String)value, PRIMITIVE_TO_WRAPPED.get(javaType.toLowerCase()));
            }
            Class<Number> numberTypeClass = Class.forName(javaType).asSubclass(Number.class);
            return NumberUtils.parseNumber((String)value, numberTypeClass);
        }

        static {
            PRIMITIVE_TO_WRAPPED.put(Byte.TYPE.getName(), Byte.class);
            PRIMITIVE_TO_WRAPPED.put(Short.TYPE.getName(), Short.class);
            PRIMITIVE_TO_WRAPPED.put(Integer.TYPE.getName(), Integer.class);
            PRIMITIVE_TO_WRAPPED.put(Long.TYPE.getName(), Long.class);
            PRIMITIVE_TO_WRAPPED.put(Float.TYPE.getName(), Float.class);
            PRIMITIVE_TO_WRAPPED.put(Double.TYPE.getName(), Double.class);
        }
    }
}

