/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.retry;

import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.context.RetryContextSupport;

public class SqlRetryPolicy
implements RetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlRetryPolicy.class);
    private final BinaryExceptionClassifier binaryExceptionClassifier = new BinaryExceptionClassifier(SqlRetryPolicy.getSqlRetryAbleExceptions(), false);
    private int maxNumberOfRetries = 3;

    private static Map<Class<? extends Throwable>, Boolean> getSqlRetryAbleExceptions() {
        HashMap<Class<? extends Throwable>, Boolean> retryableExceptions = new HashMap<Class<? extends Throwable>, Boolean>();
        retryableExceptions.put(SQLTransientException.class, true);
        retryableExceptions.put(SQLRecoverableException.class, true);
        retryableExceptions.put(TransientDataAccessException.class, true);
        retryableExceptions.put(SQLNonTransientConnectionException.class, true);
        return retryableExceptions;
    }

    public boolean canRetry(RetryContext context) {
        Throwable candidate = context.getLastThrowable();
        if (candidate == null) {
            return true;
        }
        return context.getRetryCount() <= this.maxNumberOfRetries && this.isRetryAbleException(candidate);
    }

    public RetryContext open(RetryContext parent) {
        return new RetryContextSupport(parent);
    }

    public void close(RetryContext context) {
    }

    public void registerThrowable(RetryContext context, Throwable throwable) {
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    private boolean isRetryAbleException(Throwable throwable) {
        boolean retryAble = this.binaryExceptionClassifier.classify(throwable);
        if (!retryAble) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Retry on Exception: {} not possible trying cause", (Object)throwable.getClass().getName());
            }
            if (throwable.getCause() != null) {
                return this.isRetryAbleException(throwable.getCause());
            }
            return false;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Retry possible due to exception class {}", (Object)throwable.getClass().getName());
        }
        return true;
    }

    public void setMaxNumberOfRetries(int maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }
}

