/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.datasource.support;

import org.springframework.util.Assert;

public enum DatabaseType {
    MYSQL,
    ORACLE,
    SQLSERVER,
    POSTGRES,
    MARIA,
    AURORA_POSTGRESQL,
    AURORA;


    public static DatabaseType fromEngine(String engineName) {
        Assert.notNull((Object)engineName, (String)"Engine must not be null");
        String lookupName = engineName.toUpperCase().replace("-", "_");
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!lookupName.startsWith(databaseType.toString())) continue;
            return databaseType;
        }
        throw new IllegalStateException("No database type found for engine:'" + engineName + "'");
    }
}

