/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.config.xml;

import io.awspring.cloud.context.config.xml.GlobalBeanDefinitionUtils;
import io.awspring.cloud.core.config.xml.XmlWebserviceConfigurationUtils;
import io.awspring.cloud.jdbc.retry.DatabaseInstanceStatusRetryPolicy;
import io.awspring.cloud.jdbc.retry.RdbmsRetryOperationsInterceptor;
import io.awspring.cloud.jdbc.retry.SqlRetryPolicy;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

@Deprecated
class AmazonRdsRetryInterceptorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String RETRY_OPERATIONS_CLASS_NAME = "org.springframework.retry.support.RetryTemplate";
    private static final String COMPOSITE_RETRY_POLICY_CLASS_NAME = "org.springframework.retry.policy.CompositeRetryPolicy";
    private static final String MAX_NUMBER_OF_RETRIES = "max-number-of-retries";
    private static final String BACK_OFF_POLICY = "back-off-policy";
    private static final String AMAZON_RDS_CLIENT_CLASS_NAME = "com.amazonaws.services.rds.AmazonRDSClient";

    AmazonRdsRetryInterceptorBeanDefinitionParser() {
    }

    private static BeanDefinition buildRetryOperationDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)RETRY_OPERATIONS_CLASS_NAME);
        builder.addPropertyValue("retryPolicy", (Object)AmazonRdsRetryInterceptorBeanDefinitionParser.buildRetryPolicyDefinition(element, parserContext));
        if (StringUtils.hasText((String)element.getAttribute(BACK_OFF_POLICY))) {
            String backOffPolicyBeanName = element.getAttribute(BACK_OFF_POLICY);
            builder.addPropertyReference(Conventions.attributeNameToPropertyName((String)BACK_OFF_POLICY), backOffPolicyBeanName);
        }
        return builder.getBeanDefinition();
    }

    private static BeanDefinition buildRetryPolicyDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)COMPOSITE_RETRY_POLICY_CLASS_NAME);
        ManagedList policies = new ManagedList(2);
        policies.add((Object)AmazonRdsRetryInterceptorBeanDefinitionParser.buildDatabaseInstancePolicy(element, parserContext));
        policies.add((Object)AmazonRdsRetryInterceptorBeanDefinitionParser.buildSQLRetryPolicy(element));
        builder.addPropertyValue("policies", (Object)policies);
        return builder.getBeanDefinition();
    }

    private static BeanDefinition buildDatabaseInstancePolicy(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(DatabaseInstanceStatusRetryPolicy.class);
        String amazonRdsClientBeanName = XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-rds", (String)AMAZON_RDS_CLIENT_CLASS_NAME);
        beanDefinitionBuilder.addConstructorArgReference(amazonRdsClientBeanName);
        beanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("db-instance-identifier"));
        String resourceIdResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)parserContext.getRegistry());
        beanDefinitionBuilder.addPropertyReference("resourceIdResolver", resourceIdResolverBeanName);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    private static BeanDefinition buildSQLRetryPolicy(Element element) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(SqlRetryPolicy.class);
        if (StringUtils.hasText((String)element.getAttribute(MAX_NUMBER_OF_RETRIES))) {
            beanDefinitionBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)MAX_NUMBER_OF_RETRIES), (Object)element.getAttribute(MAX_NUMBER_OF_RETRIES));
        }
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected Class<?> getBeanClass(Element element) {
        return RdbmsRetryOperationsInterceptor.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("retryOperations", (Object)AmazonRdsRetryInterceptorBeanDefinitionParser.buildRetryOperationDefinition(element, parserContext));
    }
}

