/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.config.xml;

import io.awspring.cloud.context.config.xml.GlobalBeanDefinitionUtils;
import io.awspring.cloud.core.config.AmazonWebserviceClientConfigurationUtils;
import io.awspring.cloud.core.config.xml.XmlWebserviceConfigurationUtils;
import io.awspring.cloud.jdbc.datasource.TomcatJdbcDataSourceFactory;
import io.awspring.cloud.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import io.awspring.cloud.jdbc.rds.AmazonRdsReadReplicaAwareDataSourceFactoryBean;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Deprecated
class AmazonRdsDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    static final String DB_INSTANCE_IDENTIFIER = "db-instance-identifier";
    private static final String AMAZON_RDS_CLIENT_CLASS_NAME = "com.amazonaws.services.rds.AmazonRDSClient";
    private static final String IDENTITY_MANAGEMENT_CLIENT_CLASS_NAME = "com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient";
    private static final String USER_TAG_FACTORY_BEAN_CLASS_NAME = "io.awspring.cloud.jdbc.rds.AmazonRdsDataSourceUserTagsFactoryBean";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String DATABASE_NAME = "database-name";

    AmazonRdsDataSourceBeanDefinitionParser() {
    }

    private static AbstractBeanDefinition createDataSourceFactoryBeanDefinition(Element element) {
        BeanDefinitionBuilder datasourceFactoryBuilder = BeanDefinitionBuilder.rootBeanDefinition(TomcatJdbcDataSourceFactory.class);
        Element poolAttributes = DomUtils.getChildElementByTagName((Element)element, (String)"pool-attributes");
        if (poolAttributes != null) {
            NamedNodeMap attributes = poolAttributes.getAttributes();
            int x = attributes.getLength();
            for (int i = 0; i < x; ++i) {
                Node item = attributes.item(i);
                datasourceFactoryBuilder.addPropertyValue(item.getNodeName(), (Object)item.getNodeValue());
            }
        }
        return datasourceFactoryBuilder.getBeanDefinition();
    }

    private static void registerUserTagsMapIfNecessary(Element element, ParserContext parserContext, String rdsClientBeanName) {
        BeanDefinitionBuilder beanDefinitionBuilder;
        if (!StringUtils.hasText((String)element.getAttribute("user-tags-map"))) {
            return;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)USER_TAG_FACTORY_BEAN_CLASS_NAME);
        builder.addConstructorArgReference(rdsClientBeanName);
        builder.addConstructorArgValue((Object)element.getAttribute(DB_INSTANCE_IDENTIFIER));
        builder.addConstructorArgReference(XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-identity-management", (String)IDENTITY_MANAGEMENT_CLIENT_CLASS_NAME));
        if (StringUtils.hasText((String)element.getAttribute("region"))) {
            beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"com.amazonaws.regions.Region");
            beanDefinitionBuilder.setFactoryMethod("getRegion");
            beanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("region"));
            builder.addPropertyValue("region", (Object)beanDefinitionBuilder.getBeanDefinition());
        } else {
            beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingFactoryBean.class);
            if (StringUtils.hasText((String)element.getAttribute("region-provider"))) {
                beanDefinitionBuilder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(element.getAttribute("region-provider")));
            } else {
                beanDefinitionBuilder.addPropertyValue("targetObject", (Object)new RuntimeBeanReference(AmazonWebserviceClientConfigurationUtils.getRegionProviderBeanName((BeanDefinitionRegistry)parserContext.getRegistry())));
            }
            beanDefinitionBuilder.addPropertyValue("targetMethod", (Object)"getRegion");
            builder.addPropertyValue("region", (Object)beanDefinitionBuilder.getBeanDefinition());
        }
        String resourceResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)parserContext.getRegistry());
        builder.addPropertyReference("resourceIdResolver", resourceResolverBeanName);
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute("user-tags-map"), (BeanDefinition)builder.getBeanDefinition());
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder datasourceBuilder = this.getBeanDefinitionBuilderForDataSource(element);
        String amazonRdsClientBeanName = XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-rds", (String)AMAZON_RDS_CLIENT_CLASS_NAME);
        datasourceBuilder.addConstructorArgReference(amazonRdsClientBeanName);
        datasourceBuilder.addConstructorArgValue((Object)element.getAttribute(DB_INSTANCE_IDENTIFIER));
        datasourceBuilder.addConstructorArgValue((Object)element.getAttribute(PASSWORD));
        if (StringUtils.hasText((String)element.getAttribute(USERNAME))) {
            datasourceBuilder.addPropertyValue(USERNAME, (Object)element.getAttribute(USERNAME));
        }
        if (StringUtils.hasText((String)element.getAttribute(DATABASE_NAME))) {
            datasourceBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)DATABASE_NAME), (Object)element.getAttribute(DATABASE_NAME));
        }
        datasourceBuilder.addPropertyValue("dataSourceFactory", (Object)AmazonRdsDataSourceBeanDefinitionParser.createDataSourceFactoryBeanDefinition(element));
        String resourceResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)parserContext.getRegistry());
        datasourceBuilder.addPropertyReference("resourceIdResolver", resourceResolverBeanName);
        AmazonRdsDataSourceBeanDefinitionParser.registerUserTagsMapIfNecessary(element, parserContext, amazonRdsClientBeanName);
        return datasourceBuilder.getBeanDefinition();
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilderForDataSource(Element element) {
        BeanDefinitionBuilder datasourceBuilder = Boolean.TRUE.toString().equalsIgnoreCase(element.getAttribute("read-replica-support")) ? BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsReadReplicaAwareDataSourceFactoryBean.class) : BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsDataSourceFactoryBean.class);
        return datasourceBuilder;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return element.getAttribute(DB_INSTANCE_IDENTIFIER);
    }
}

