/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.config.annotation;

import io.awspring.cloud.jdbc.config.annotation.RdsInstanceConfigurer;
import io.awspring.cloud.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RdsInstanceConfigurerBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private RdsInstanceConfigurer rdsInstanceConfigurer;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AmazonRdsDataSourceFactoryBean && this.rdsInstanceConfigurer != null) {
            ((AmazonRdsDataSourceFactoryBean)((Object)bean)).setDataSourceFactory(this.rdsInstanceConfigurer.getDataSourceFactory());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ListableBeanFactory) {
            Collection configurer = ((ListableBeanFactory)beanFactory).getBeansOfType(RdsInstanceConfigurer.class).values();
            if (configurer.isEmpty()) {
                return;
            }
            if (configurer.size() > 1) {
                throw new IllegalStateException("Only one RdsInstanceConfigurer may exist");
            }
            this.rdsInstanceConfigurer = (RdsInstanceConfigurer)configurer.iterator().next();
        }
    }
}

