/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DefaultDynamoDbTableNameResolver;
import io.awspring.cloud.dynamodb.DefaultDynamoDbTableSchemaResolver;
import io.awspring.cloud.dynamodb.DynamoDbOperations;
import io.awspring.cloud.dynamodb.DynamoDbTableNameResolver;
import io.awspring.cloud.dynamodb.DynamoDbTableSchemaResolver;
import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;

public class DynamoDbTemplate
implements DynamoDbOperations {
    private final DynamoDbEnhancedClient dynamoDbEnhancedClient;
    private final DynamoDbTableSchemaResolver dynamoDbTableSchemaResolver;
    private final DynamoDbTableNameResolver tableNameResolver;

    public DynamoDbTemplate(@Nullable String tablePrefix, DynamoDbEnhancedClient dynamoDbEnhancedClient) {
        this(dynamoDbEnhancedClient, new DefaultDynamoDbTableSchemaResolver(Collections.emptyList()), new DefaultDynamoDbTableNameResolver(tablePrefix));
    }

    public DynamoDbTemplate(DynamoDbEnhancedClient dynamoDbEnhancedClient) {
        this(dynamoDbEnhancedClient, new DefaultDynamoDbTableSchemaResolver(Collections.emptyList()), new DefaultDynamoDbTableNameResolver());
    }

    public DynamoDbTemplate(DynamoDbEnhancedClient dynamoDbEnhancedClient, DynamoDbTableSchemaResolver dynamoDbTableSchemaResolver, DynamoDbTableNameResolver tableNameResolver) {
        this.dynamoDbEnhancedClient = dynamoDbEnhancedClient;
        this.dynamoDbTableSchemaResolver = dynamoDbTableSchemaResolver;
        this.tableNameResolver = tableNameResolver;
    }

    @Override
    public <T> T save(T entity) {
        Assert.notNull(entity, (String)"entity is required");
        this.prepareTable(entity).putItem(entity);
        return entity;
    }

    @Override
    public <T> T update(T entity) {
        Assert.notNull(entity, (String)"entity is required");
        return (T)this.prepareTable(entity).updateItem(entity);
    }

    @Override
    public <T> T delete(Key key, Class<T> clazz) {
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull(clazz, (String)"clazz is required");
        return (T)this.prepareTable(clazz).deleteItem(key);
    }

    @Override
    public <T> T delete(T entity) {
        Assert.notNull(entity, (String)"entity is required");
        return (T)this.prepareTable(entity).deleteItem(entity);
    }

    @Override
    @Nullable
    public <T> T load(Key key, Class<T> clazz) {
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull(clazz, (String)"clazz is required");
        return (T)this.prepareTable(clazz).getItem(key);
    }

    @Override
    public <T> PageIterable<T> scan(ScanEnhancedRequest scanEnhancedRequest, Class<T> clazz) {
        Assert.notNull((Object)scanEnhancedRequest, (String)"scanEnhancedRequest is required");
        Assert.notNull(clazz, (String)"clazz is required");
        return this.prepareTable(clazz).scan(scanEnhancedRequest);
    }

    @Override
    public <T> PageIterable<T> scan(ScanEnhancedRequest scanEnhancedRequest, Class<T> clazz, String indexName) {
        return PageIterable.create((SdkIterable)this.prepareTable(clazz).index(indexName).scan(scanEnhancedRequest));
    }

    @Override
    public <T> PageIterable<T> scanAll(Class<T> clazz, String indexName) {
        return PageIterable.create((SdkIterable)this.prepareTable(clazz).index(indexName).scan());
    }

    @Override
    public <T> PageIterable<T> query(QueryEnhancedRequest queryEnhancedRequest, Class<T> clazz, String indexName) {
        return PageIterable.create((SdkIterable)this.prepareTable(clazz).index(indexName).query(queryEnhancedRequest));
    }

    @Override
    public <T> PageIterable<T> scanAll(Class<T> clazz) {
        Assert.notNull(clazz, (String)"clazz is required");
        return this.prepareTable(clazz).scan();
    }

    @Override
    public <T> PageIterable<T> query(QueryEnhancedRequest queryEnhancedRequest, Class<T> clazz) {
        Assert.notNull((Object)queryEnhancedRequest, (String)"queryEnhancedRequest is required");
        Assert.notNull(clazz, (String)"clazz is required");
        return this.prepareTable(clazz).query(queryEnhancedRequest);
    }

    private <T> DynamoDbTable<T> prepareTable(T entity) {
        Assert.notNull(entity, (String)"entity is required");
        String tableName = this.tableNameResolver.resolve(entity.getClass());
        return this.dynamoDbEnhancedClient.table(tableName, this.dynamoDbTableSchemaResolver.resolve(entity.getClass()));
    }

    private <T> DynamoDbTable<T> prepareTable(Class<T> clazz) {
        Assert.notNull(clazz, (String)"clazz is required");
        String tableName = this.tableNameResolver.resolve(clazz);
        return this.dynamoDbEnhancedClient.table(tableName, this.dynamoDbTableSchemaResolver.resolve(clazz));
    }
}

