/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.s3;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.config.AbstractAwsConfigDataLocationResolver;
import io.awspring.cloud.autoconfigure.config.s3.S3ConfigDataResource;
import io.awspring.cloud.autoconfigure.config.s3.S3KeysMissingException;
import io.awspring.cloud.autoconfigure.config.s3.S3PropertySources;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.core.CredentialsProperties;
import io.awspring.cloud.autoconfigure.core.RegionProperties;
import io.awspring.cloud.autoconfigure.s3.S3ClientCustomizer;
import io.awspring.cloud.autoconfigure.s3.properties.S3Properties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3ConfigDataLocationResolver
extends AbstractAwsConfigDataLocationResolver<S3ConfigDataResource> {
    public static final String PREFIX = "aws-s3:";
    private final Log log;

    public S3ConfigDataLocationResolver(DeferredLogFactory deferredLogFactory) {
        this.log = deferredLogFactory.getLog(S3ConfigDataLocationResolver.class);
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    @Override
    public List<S3ConfigDataResource> resolve(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location) throws ConfigDataLocationNotFoundException {
        S3Properties s3Properties = this.loadProperties(resolverContext.getBinder());
        ArrayList<S3ConfigDataResource> locations = new ArrayList<S3ConfigDataResource>();
        S3PropertySources propertySources = new S3PropertySources();
        List<String> contexts = this.getCustomContexts(location.getNonPrefixedValue(PREFIX));
        if (s3Properties.getConfig().isEnabled()) {
            this.registerBean(resolverContext, AwsProperties.class, this.loadAwsProperties(resolverContext.getBinder()));
            this.registerBean(resolverContext, S3Properties.class, s3Properties);
            this.registerBean(resolverContext, CredentialsProperties.class, this.loadCredentialsProperties(resolverContext.getBinder()));
            this.registerBean(resolverContext, RegionProperties.class, this.loadRegionProperties(resolverContext.getBinder()));
            this.registerAndPromoteBean(resolverContext, S3Client.class, this::createS3Client);
            contexts.forEach(propertySourceContext -> locations.add(new S3ConfigDataResource((String)propertySourceContext, location.isOptional(), propertySources)));
            if (!location.isOptional() && locations.isEmpty()) {
                throw new S3KeysMissingException("No S3 keys provided in `spring.config.import=aws-s3:` configuration.");
            }
        } else {
            contexts.forEach(propertySourceContext -> locations.add(new S3ConfigDataResource((String)propertySourceContext, location.isOptional(), false, propertySources)));
        }
        return locations;
    }

    private S3Client createS3Client(BootstrapContext context) {
        S3ClientBuilder builder = this.configure(S3Client.builder(), (AwsClientProperties)context.get(S3Properties.class), context);
        try {
            S3ClientCustomizer s3ClientCustomizer = (S3ClientCustomizer)context.get(S3ClientCustomizer.class);
            if (s3ClientCustomizer != null) {
                s3ClientCustomizer.customize(builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type AwsSyncClientCustomizer is not registered: " + e.getMessage()));
        }
        try {
            AwsSyncClientCustomizer awsSyncClientCustomizer = (AwsSyncClientCustomizer)context.get(AwsSyncClientCustomizer.class);
            if (awsSyncClientCustomizer != null) {
                awsSyncClientCustomizer.customize((AwsSyncClientBuilder<?, ?>)builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type AwsSyncClientCustomizer is not registered: " + e.getMessage()));
        }
        return (S3Client)builder.build();
    }

    protected S3Properties loadProperties(Binder binder) {
        return (S3Properties)binder.bind("spring.cloud.aws.s3", Bindable.of(S3Properties.class)).orElseGet(S3Properties::new);
    }
}

