/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.parameterstore;

import io.awspring.cloud.autoconfigure.config.BootstrapLoggingHelper;
import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStoreConfigDataResource;
import io.awspring.cloud.parameterstore.ParameterStorePropertySource;
import java.util.Collections;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.MapPropertySource;
import software.amazon.awssdk.services.ssm.SsmClient;

public class ParameterStoreConfigDataLoader
implements ConfigDataLoader<ParameterStoreConfigDataResource> {
    public ParameterStoreConfigDataLoader(DeferredLogFactory logFactory) {
        BootstrapLoggingHelper.reconfigureLoggers(logFactory, "io.awspring.cloud.parameterstore.ParameterStorePropertySource", "io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStorePropertySources");
    }

    public @Nullable ConfigData load(ConfigDataLoaderContext context, ParameterStoreConfigDataResource resource) {
        if (resource.isEnabled()) {
            SsmClient ssm = (SsmClient)context.getBootstrapContext().get(SsmClient.class);
            ParameterStorePropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), ssm);
            if (propertySource != null) {
                return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
            }
            return null;
        }
        return new ConfigData(Collections.singletonList(new MapPropertySource("aws-parameterstore:" + context, Map.of())), new ConfigData.Option[0]);
    }
}

