/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.context;

import io.awspring.cloud.autoconfigure.context.properties.AwsRegionProperties;
import io.awspring.cloud.core.config.AmazonWebserviceClientConfigurationUtils;
import io.awspring.cloud.core.region.DefaultAwsRegionProviderChainDelegate;
import io.awspring.cloud.core.region.StaticRegionProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Configuration(proxyBeanMethods=false)
@Import(value={Registrar.class})
@EnableConfigurationProperties(value={AwsRegionProperties.class})
public class ContextRegionProviderAutoConfiguration {

    static class Registrar
    implements EnvironmentAware,
    ImportBeanDefinitionRegistrar {
        private Environment environment;

        Registrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition("regionProvider")) {
                registry.registerBeanDefinition("regionProvider", this.createRegionProviderBeanDefinition(this.awsRegionProperties()));
                AmazonWebserviceClientConfigurationUtils.replaceDefaultRegionProvider((BeanDefinitionRegistry)registry, (String)"regionProvider");
            }
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        private BeanDefinition createRegionProviderBeanDefinition(AwsRegionProperties properties) {
            return properties.isStatic() ? BeanDefinitionBuilder.genericBeanDefinition(StaticRegionProvider.class).addConstructorArgValue((Object)properties.getStatic()).getBeanDefinition() : BeanDefinitionBuilder.genericBeanDefinition(DefaultAwsRegionProviderChainDelegate.class).getBeanDefinition();
        }

        private AwsRegionProperties awsRegionProperties() {
            return (AwsRegionProperties)Binder.get((Environment)this.environment).bindOrCreate("cloud.aws.region", AwsRegionProperties.class);
        }
    }
}

