/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileCopyUtils {
    private FileCopyUtils() {
    }

    public static String copyToString(InputStream inputStream, Charset charset) {
        return FileCopyUtils.copyToString(new InputStreamReader(inputStream, charset));
    }

    public static String copyToString(Reader in) {
        StringWriter out = new StringWriter();
        FileCopyUtils.copy(in, out);
        String str = out.toString();
        if (str.startsWith("\ufeff")) {
            return str.substring(1);
        }
        return str;
    }

    private static void copy(Reader in, Writer out) {
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            return Collections.emptyList();
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

