/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.SessionRequest;
import java.util.Objects;

public class ResetRequest
extends SessionRequest {
    private long index;

    public static Builder builder() {
        return new Builder(new ResetRequest());
    }

    public static Builder builder(ResetRequest response) {
        return new Builder(response);
    }

    public long index() {
        return this.index;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.index = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.index);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.index);
    }

    public boolean equals(Object object) {
        if (object instanceof ResetRequest) {
            ResetRequest request = (ResetRequest)object;
            return request.session == this.session && request.index == this.index;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[session=%d, index=%d]", this.getClass().getSimpleName(), this.session, this.index);
    }

    public static class Builder
    extends SessionRequest.Builder<Builder, ResetRequest> {
        protected Builder(ResetRequest response) {
            super(response);
        }

        public Builder withIndex(long index) {
            ((ResetRequest)this.request).index = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"index cannot be less than 0", (Object[])new Object[0]);
            return this;
        }

        @Override
        public ResetRequest build() {
            super.build();
            Assert.stateNot((((ResetRequest)this.request).index < 0L ? 1 : 0) != 0, (String)"index cannot be less than 0", (Object[])new Object[0]);
            return (ResetRequest)this.request;
        }
    }
}

