/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.concurrent;

import io.atomix.catalyst.concurrent.CatalystThread;
import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;

public interface ThreadContext
extends AutoCloseable {
    public static ThreadContext currentContext() {
        Thread thread = Thread.currentThread();
        return thread instanceof CatalystThread ? ((CatalystThread)thread).getContext() : null;
    }

    public static ThreadContext currentContextOrThrow() {
        ThreadContext context = ThreadContext.currentContext();
        Assert.state((context != null ? 1 : 0) != 0, (String)"not on a Catalyst thread", (Object[])new Object[0]);
        return context;
    }

    default public boolean isCurrentContext() {
        return ThreadContext.currentContext() == this;
    }

    default public void checkThread() {
        Assert.state((ThreadContext.currentContext() == this ? 1 : 0) != 0, (String)"not on a Catalyst thread", (Object[])new Object[0]);
    }

    public Logger logger();

    public Serializer serializer();

    public Executor executor();

    public boolean isBlocked();

    public void block();

    public void unblock();

    default public CompletableFuture<Void> execute(Runnable callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor().execute(() -> {
            try {
                callback.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    default public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        CompletableFuture future = new CompletableFuture();
        this.executor().execute(() -> {
            try {
                future.complete(callback.get());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public Scheduled schedule(Duration var1, Runnable var2);

    public Scheduled schedule(Duration var1, Duration var2, Runnable var3);

    @Override
    public void close();
}

