/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.net;

import io.atomix.utils.net.MalformedAddressException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public final class Address {
    private static final int DEFAULT_PORT = 5679;
    private final String host;
    private final int port;
    private volatile transient Type type;
    private volatile transient InetAddress address;

    public static Address local() {
        return Address.from(5679);
    }

    public static Address from(String address) {
        int port;
        int lastColon = address.lastIndexOf(58);
        int openBracket = address.indexOf(91);
        int closeBracket = address.indexOf(93);
        String host = openBracket != -1 && closeBracket != -1 ? address.substring(openBracket + 1, closeBracket) : (lastColon != -1 ? address.substring(0, lastColon) : address);
        if (lastColon != -1) {
            try {
                port = Integer.parseInt(address.substring(lastColon + 1));
            }
            catch (NumberFormatException e) {
                throw new MalformedAddressException(address, e);
            }
        } else {
            port = 5679;
        }
        return new Address(host, port);
    }

    public static Address from(String host, int port) {
        return new Address(host, port);
    }

    public static Address from(int port) {
        try {
            InetAddress address = Address.getLocalAddress();
            return new Address(address.getHostName(), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to locate host", e);
        }
    }

    private static InetAddress getLocalAddress() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception ignore) {
            return InetAddress.getByName(null);
        }
    }

    public Address(String host, int port) {
        this(host, port, null);
    }

    public Address(String host, int port, InetAddress address) {
        this.host = host;
        this.port = port;
        this.address = address;
        if (address != null) {
            this.type = address instanceof Inet6Address ? Type.IPV6 : Type.IPV4;
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public InetAddress address() {
        return this.address(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress address(boolean resolve) {
        if (resolve) {
            this.address = this.resolveAddress();
            return this.address;
        }
        if (this.address == null) {
            Address address = this;
            synchronized (address) {
                if (this.address == null) {
                    this.address = this.resolveAddress();
                }
            }
        }
        return this.address;
    }

    private InetAddress resolveAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type type() {
        if (this.type == null) {
            Address address = this;
            synchronized (address) {
                if (this.type == null) {
                    this.type = this.address() instanceof Inet6Address ? Type.IPV6 : Type.IPV4;
                }
            }
        }
        return this.type;
    }

    public String toString() {
        String host = this.host();
        int port = this.port();
        if (host.matches("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}")) {
            return String.format("[%s]:%d", host, port);
        }
        return String.format("%s:%d", host, port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address that = (Address)obj;
        return this.host.equals(that.host) && this.port == that.port;
    }

    public static enum Type {
        IPV4,
        IPV6;

    }
}

