/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.NullThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class OrderedFuture<T>
extends CompletableFuture<T> {
    private static final ThreadContext NULL_CONTEXT = new NullThreadContext();
    private final Queue<CompletableFuture<T>> orderedFutures = new LinkedList<CompletableFuture<T>>();
    private volatile boolean complete;
    private volatile T result;
    private volatile Throwable error;

    public static <T> CompletableFuture<T> wrap(CompletableFuture<T> future) {
        OrderedFuture newFuture = new OrderedFuture();
        future.whenComplete((T result, U error) -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                newFuture.completeExceptionally((Throwable)error);
            }
        });
        return newFuture;
    }

    public OrderedFuture() {
        super.whenComplete(this::complete);
    }

    private ThreadContext getThreadContext() {
        ThreadContext context = ThreadContext.currentContext();
        return context != null ? context : NULL_CONTEXT;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        ThreadContext context = this.getThreadContext();
        context.block();
        try {
            Object t = super.get();
            return t;
        }
        finally {
            context.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ThreadContext context = this.getThreadContext();
        context.block();
        try {
            Object t = super.get(timeout, unit);
            return t;
        }
        finally {
            context.unblock();
        }
    }

    @Override
    public synchronized T join() {
        ThreadContext context = this.getThreadContext();
        context.block();
        try {
            Object t = super.join();
            return t;
        }
        finally {
            context.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<T> orderedFuture() {
        if (!this.complete) {
            Queue<CompletableFuture<T>> queue = this.orderedFutures;
            synchronized (queue) {
                if (!this.complete) {
                    CompletableFuture future = new CompletableFuture();
                    this.orderedFutures.add(future);
                    return future;
                }
            }
        }
        if (this.error == null) {
            return CompletableFuture.completedFuture(this.result);
        }
        return Futures.exceptionalFuture(this.error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(T result, Throwable error) {
        Queue<CompletableFuture<T>> queue = this.orderedFutures;
        synchronized (queue) {
            this.result = result;
            this.error = error;
            this.complete = true;
            if (error == null) {
                for (CompletableFuture completableFuture : this.orderedFutures) {
                    completableFuture.complete(result);
                }
            } else {
                for (CompletableFuture completableFuture : this.orderedFutures) {
                    completableFuture.completeExceptionally(error);
                }
            }
            this.orderedFutures.clear();
        }
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return OrderedFuture.wrap(this.orderedFuture().thenApply(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return OrderedFuture.wrap(this.orderedFuture().thenApplyAsync(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().thenApplyAsync(fn, executor));
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return OrderedFuture.wrap(this.orderedFuture().thenAccept((Consumer)action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return OrderedFuture.wrap(this.orderedFuture().thenAcceptAsync((Consumer)action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().thenAcceptAsync((Consumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return OrderedFuture.wrap(this.orderedFuture().thenRun(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return OrderedFuture.wrap(this.orderedFuture().thenRunAsync(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().thenRunAsync(action, executor));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return OrderedFuture.wrap(this.orderedFuture().thenCombine(other, fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return OrderedFuture.wrap(this.orderedFuture().thenCombineAsync(other, fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().thenCombineAsync(other, fn, executor));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return OrderedFuture.wrap(this.orderedFuture().thenAcceptBoth(other, (BiConsumer)action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return OrderedFuture.wrap(this.orderedFuture().thenAcceptBothAsync(other, (BiConsumer)action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return OrderedFuture.wrap(this.orderedFuture().runAfterBoth((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return OrderedFuture.wrap(this.orderedFuture().runAfterBothAsync((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return OrderedFuture.wrap(this.orderedFuture().applyToEither((CompletionStage)other, fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return OrderedFuture.wrap(this.orderedFuture().applyToEitherAsync((CompletionStage)other, fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return OrderedFuture.wrap(this.orderedFuture().acceptEither((CompletionStage)other, (Consumer)action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return OrderedFuture.wrap(this.orderedFuture().acceptEitherAsync((CompletionStage)other, (Consumer)action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return OrderedFuture.wrap(this.orderedFuture().runAfterEither((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return OrderedFuture.wrap(this.orderedFuture().runAfterEitherAsync((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return OrderedFuture.wrap(this.orderedFuture().thenCompose(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return OrderedFuture.wrap(this.orderedFuture().thenComposeAsync(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().thenComposeAsync(fn, executor));
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return OrderedFuture.wrap(this.orderedFuture().whenComplete(action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return OrderedFuture.wrap(this.orderedFuture().whenCompleteAsync(action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().whenCompleteAsync(action, executor));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return OrderedFuture.wrap(this.orderedFuture().handle(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return OrderedFuture.wrap(this.orderedFuture().handleAsync(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return OrderedFuture.wrap(this.orderedFuture().handleAsync(fn, executor));
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return OrderedFuture.wrap(this.orderedFuture().exceptionally(fn));
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }
}

