/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.HeapMemory;
import io.atomix.utils.memory.MemoryAllocator;
import io.atomix.utils.memory.NativeMemory;

public class HeapMemoryAllocator
implements MemoryAllocator<HeapMemory> {
    @Override
    public HeapMemory allocate(int size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size cannot be greater than 2147483647");
        }
        return new HeapMemory(new byte[size], this);
    }

    @Override
    public HeapMemory reallocate(HeapMemory memory, int size) {
        HeapMemory copy = this.allocate(size);
        NativeMemory.UNSAFE.copyMemory(memory.array(), HeapMemory.ARRAY_BASE_OFFSET, copy.array(), HeapMemory.ARRAY_BASE_OFFSET, Math.min(size, memory.size()));
        memory.free();
        return copy;
    }
}

