/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.test.protocol;

import com.google.common.collect.Maps;
import io.atomix.cluster.MemberId;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.test.protocol.LocalRaftClientProtocol;
import io.atomix.protocols.raft.test.protocol.LocalRaftServerProtocol;
import io.atomix.utils.serializer.Serializer;
import java.util.Map;

public class LocalRaftProtocolFactory {
    private final Serializer serializer;
    private final Map<MemberId, LocalRaftServerProtocol> servers = Maps.newConcurrentMap();
    private final Map<MemberId, LocalRaftClientProtocol> clients = Maps.newConcurrentMap();

    public LocalRaftProtocolFactory(Serializer serializer) {
        this.serializer = serializer;
    }

    public RaftClientProtocol newClientProtocol(MemberId memberId) {
        return new LocalRaftClientProtocol(memberId, this.serializer, this.servers, this.clients);
    }

    public RaftServerProtocol newServerProtocol(MemberId memberId) {
        return new LocalRaftServerProtocol(memberId, this.serializer, this.servers, this.clients);
    }
}

