/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.cluster.NodeId;
import io.atomix.messaging.MessagingService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftMessagingProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Serializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class RaftClientMessagingProtocol
extends RaftMessagingProtocol
implements RaftClientProtocol {
    public RaftClientMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<NodeId, Address> addressProvider) {
        super(messagingService, serializer, addressProvider);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(NodeId nodeId, OpenSessionRequest request) {
        return this.sendAndReceive(nodeId, "open-session", request);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(NodeId nodeId, CloseSessionRequest request) {
        return this.sendAndReceive(nodeId, "close-session", request);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(NodeId nodeId, KeepAliveRequest request) {
        return this.sendAndReceive(nodeId, "keep-alive", request);
    }

    @Override
    public CompletableFuture<QueryResponse> query(NodeId nodeId, QueryRequest request) {
        return this.sendAndReceive(nodeId, "query", request);
    }

    @Override
    public CompletableFuture<CommandResponse> command(NodeId nodeId, CommandRequest request) {
        return this.sendAndReceive(nodeId, "command", request);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(NodeId nodeId, MetadataRequest request) {
        return this.sendAndReceive(nodeId, "metadata", request);
    }

    @Override
    public void registerHeartbeatHandler(Function<HeartbeatRequest, CompletableFuture<HeartbeatResponse>> handler) {
        this.registerHandler("heartbeat", handler);
    }

    @Override
    public void unregisterHeartbeatHandler() {
        this.unregisterHandler("heartbeat");
    }

    @Override
    public void reset(Set<NodeId> members, ResetRequest request) {
        for (NodeId nodeId : members) {
            this.sendAsync(nodeId, String.format("reset-%d", request.session()), request);
        }
    }

    @Override
    public void registerPublishListener(SessionId sessionId, Consumer<PublishRequest> listener, Executor executor) {
        this.messagingService.registerHandler(String.format("publish-%d", sessionId.id()), (e, p) -> listener.accept((PublishRequest)this.serializer.decode(p)), executor);
    }

    @Override
    public void unregisterPublishListener(SessionId sessionId) {
        this.messagingService.unregisterHandler(String.format("publish-%d", sessionId.id()));
    }
}

