/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.collect.Maps;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.LocalRaftClientProtocol;
import io.atomix.protocols.raft.protocol.LocalRaftProtocol;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class LocalRaftServerProtocol
extends LocalRaftProtocol
implements RaftServerProtocol {
    private Function<OpenSessionRequest, CompletableFuture<OpenSessionResponse>> openSessionHandler;
    private Function<CloseSessionRequest, CompletableFuture<CloseSessionResponse>> closeSessionHandler;
    private Function<KeepAliveRequest, CompletableFuture<KeepAliveResponse>> keepAliveHandler;
    private Function<QueryRequest, CompletableFuture<QueryResponse>> queryHandler;
    private Function<CommandRequest, CompletableFuture<CommandResponse>> commandHandler;
    private Function<MetadataRequest, CompletableFuture<MetadataResponse>> metadataHandler;
    private Function<JoinRequest, CompletableFuture<JoinResponse>> joinHandler;
    private Function<LeaveRequest, CompletableFuture<LeaveResponse>> leaveHandler;
    private Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> configureHandler;
    private Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> reconfigureHandler;
    private Function<InstallRequest, CompletableFuture<InstallResponse>> installHandler;
    private Function<PollRequest, CompletableFuture<PollResponse>> pollHandler;
    private Function<VoteRequest, CompletableFuture<VoteResponse>> voteHandler;
    private Function<TransferRequest, CompletableFuture<TransferResponse>> transferHandler;
    private Function<AppendRequest, CompletableFuture<AppendResponse>> appendHandler;
    private final Map<Long, Consumer<ResetRequest>> resetListeners = Maps.newConcurrentMap();

    public LocalRaftServerProtocol(NodeId nodeId, Serializer serializer, Map<NodeId, LocalRaftServerProtocol> servers, Map<NodeId, LocalRaftClientProtocol> clients) {
        super(serializer, servers, clients);
        servers.put(nodeId, this);
    }

    private CompletableFuture<LocalRaftServerProtocol> getServer(NodeId nodeId) {
        LocalRaftServerProtocol server = this.server(nodeId);
        if (server != null) {
            return Futures.completedFuture((Object)server);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    private CompletableFuture<LocalRaftClientProtocol> getClient(NodeId nodeId) {
        LocalRaftClientProtocol client = this.client(nodeId);
        if (client != null) {
            return Futures.completedFuture((Object)client);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(NodeId nodeId, OpenSessionRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.openSession(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(NodeId nodeId, CloseSessionRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.closeSession(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(NodeId nodeId, KeepAliveRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.keepAlive(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<QueryResponse> query(NodeId nodeId, QueryRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.query(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<CommandResponse> command(NodeId nodeId, CommandRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.command(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(NodeId nodeId, MetadataRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.metadata(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<JoinResponse> join(NodeId nodeId, JoinRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.join(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<LeaveResponse> leave(NodeId nodeId, LeaveRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.leave(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<ConfigureResponse> configure(NodeId nodeId, ConfigureRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.configure(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> reconfigure(NodeId nodeId, ReconfigureRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.reconfigure(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<InstallResponse> install(NodeId nodeId, InstallRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.install(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<TransferResponse> transfer(NodeId nodeId, TransferRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.install(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<PollResponse> poll(NodeId nodeId, PollRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.poll(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(NodeId nodeId, VoteRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.vote(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public CompletableFuture<AppendResponse> append(NodeId nodeId, AppendRequest request) {
        return ((CompletableFuture)this.getServer(nodeId).thenCompose(listener -> listener.append(this.encode(request)))).thenApply(this::decode);
    }

    @Override
    public void publish(NodeId nodeId, PublishRequest request) {
        this.getClient(nodeId).thenAccept(protocol -> protocol.publish(request.session(), this.encode(request)));
    }

    @Override
    public CompletableFuture<HeartbeatResponse> heartbeat(NodeId nodeId, HeartbeatRequest request) {
        return ((CompletableFuture)this.getClient(nodeId).thenCompose(protocol -> protocol.heartbeat(this.encode(request)))).thenApply(this::decode);
    }

    CompletableFuture<byte[]> openSession(byte[] request) {
        if (this.openSessionHandler != null) {
            return this.openSessionHandler.apply((OpenSessionRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerOpenSessionHandler(Function<OpenSessionRequest, CompletableFuture<OpenSessionResponse>> handler) {
        this.openSessionHandler = handler;
    }

    @Override
    public void unregisterOpenSessionHandler() {
        this.openSessionHandler = null;
    }

    CompletableFuture<byte[]> closeSession(byte[] request) {
        if (this.closeSessionHandler != null) {
            return this.closeSessionHandler.apply((CloseSessionRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerCloseSessionHandler(Function<CloseSessionRequest, CompletableFuture<CloseSessionResponse>> handler) {
        this.closeSessionHandler = handler;
    }

    @Override
    public void unregisterCloseSessionHandler() {
        this.closeSessionHandler = null;
    }

    CompletableFuture<byte[]> keepAlive(byte[] request) {
        if (this.keepAliveHandler != null) {
            return this.keepAliveHandler.apply((KeepAliveRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerKeepAliveHandler(Function<KeepAliveRequest, CompletableFuture<KeepAliveResponse>> handler) {
        this.keepAliveHandler = handler;
    }

    @Override
    public void unregisterKeepAliveHandler() {
        this.keepAliveHandler = null;
    }

    CompletableFuture<byte[]> query(byte[] request) {
        if (this.queryHandler != null) {
            return this.queryHandler.apply((QueryRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerQueryHandler(Function<QueryRequest, CompletableFuture<QueryResponse>> handler) {
        this.queryHandler = handler;
    }

    @Override
    public void unregisterQueryHandler() {
        this.queryHandler = null;
    }

    CompletableFuture<byte[]> command(byte[] request) {
        if (this.commandHandler != null) {
            return this.commandHandler.apply((CommandRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerCommandHandler(Function<CommandRequest, CompletableFuture<CommandResponse>> handler) {
        this.commandHandler = handler;
    }

    @Override
    public void unregisterCommandHandler() {
        this.commandHandler = null;
    }

    CompletableFuture<byte[]> metadata(byte[] request) {
        if (this.metadataHandler != null) {
            return this.metadataHandler.apply((MetadataRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerMetadataHandler(Function<MetadataRequest, CompletableFuture<MetadataResponse>> handler) {
        this.metadataHandler = handler;
    }

    @Override
    public void unregisterMetadataHandler() {
        this.metadataHandler = null;
    }

    CompletableFuture<byte[]> join(byte[] request) {
        if (this.joinHandler != null) {
            return this.joinHandler.apply((JoinRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.joinHandler = handler;
    }

    @Override
    public void unregisterJoinHandler() {
        this.joinHandler = null;
    }

    CompletableFuture<byte[]> leave(byte[] request) {
        if (this.leaveHandler != null) {
            return this.leaveHandler.apply((LeaveRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.leaveHandler = handler;
    }

    @Override
    public void unregisterLeaveHandler() {
        this.leaveHandler = null;
    }

    CompletableFuture<byte[]> configure(byte[] request) {
        if (this.configureHandler != null) {
            return this.configureHandler.apply((ConfigureRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.configureHandler = handler;
    }

    @Override
    public void unregisterConfigureHandler() {
        this.configureHandler = null;
    }

    CompletableFuture<byte[]> reconfigure(byte[] request) {
        if (this.reconfigureHandler != null) {
            return this.reconfigureHandler.apply((ReconfigureRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.reconfigureHandler = handler;
    }

    @Override
    public void unregisterReconfigureHandler() {
        this.reconfigureHandler = null;
    }

    CompletableFuture<byte[]> install(byte[] request) {
        if (this.installHandler != null) {
            return this.installHandler.apply((InstallRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.installHandler = handler;
    }

    @Override
    public void unregisterInstallHandler() {
        this.installHandler = null;
    }

    CompletableFuture<byte[]> poll(byte[] request) {
        if (this.pollHandler != null) {
            return this.pollHandler.apply((PollRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.pollHandler = handler;
    }

    @Override
    public void unregisterPollHandler() {
        this.pollHandler = null;
    }

    CompletableFuture<byte[]> vote(byte[] request) {
        if (this.voteHandler != null) {
            return this.voteHandler.apply((VoteRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.voteHandler = handler;
    }

    @Override
    public void unregisterVoteHandler() {
        this.voteHandler = null;
    }

    @Override
    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.transferHandler = handler;
    }

    @Override
    public void unregisterTransferHandler() {
        this.transferHandler = null;
    }

    CompletableFuture<byte[]> transfer(byte[] request) {
        if (this.transferHandler != null) {
            return this.transferHandler.apply((TransferRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    CompletableFuture<byte[]> append(byte[] request) {
        if (this.appendHandler != null) {
            return this.appendHandler.apply((AppendRequest)this.decode(request)).thenApply(this::encode);
        }
        return Futures.exceptionalFuture((Throwable)new ConnectException());
    }

    @Override
    public void registerAppendHandler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.appendHandler = handler;
    }

    @Override
    public void unregisterAppendHandler() {
        this.appendHandler = null;
    }

    void reset(long sessionId, byte[] request) {
        Consumer<ResetRequest> listener = this.resetListeners.get(sessionId);
        if (listener != null) {
            listener.accept((ResetRequest)this.decode(request));
        }
    }

    @Override
    public void registerResetListener(SessionId sessionId, Consumer<ResetRequest> listener, Executor executor) {
        this.resetListeners.put((Long)sessionId.id(), request -> executor.execute(() -> listener.accept((ResetRequest)request)));
    }

    @Override
    public void unregisterResetListener(SessionId sessionId) {
        this.resetListeners.remove(sessionId.id());
    }
}

