/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import io.atomix.primitive.Recovery;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import java.time.Duration;
import java.util.concurrent.Executor;

public class RaftProtocolConfig
extends PrimitiveProtocolConfig<RaftProtocolConfig> {
    private Duration minTimeout = Duration.ofMillis(250L);
    private Duration maxTimeout = Duration.ofSeconds(30L);
    private ReadConsistency readConsistency = ReadConsistency.SEQUENTIAL;
    private CommunicationStrategy communicationStrategy = CommunicationStrategy.LEADER;
    private Recovery recoveryStrategy = Recovery.RECOVER;
    private int maxRetries = 0;
    private Duration retryDelay = Duration.ofMillis(100L);
    private Executor executor;

    public Duration getMinTimeout() {
        return this.minTimeout;
    }

    public RaftProtocolConfig setMinTimeout(Duration minTimeout) {
        this.minTimeout = minTimeout;
        return this;
    }

    public Duration getMaxTimeout() {
        return this.maxTimeout;
    }

    public RaftProtocolConfig setMaxTimeout(Duration maxTimeout) {
        this.maxTimeout = maxTimeout;
        return this;
    }

    public ReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public RaftProtocolConfig setReadConsistency(ReadConsistency readConsistency) {
        this.readConsistency = readConsistency;
        return this;
    }

    public CommunicationStrategy getCommunicationStrategy() {
        return this.communicationStrategy;
    }

    public RaftProtocolConfig setCommunicationStrategy(CommunicationStrategy communicationStrategy) {
        this.communicationStrategy = communicationStrategy;
        return this;
    }

    public Recovery getRecoveryStrategy() {
        return this.recoveryStrategy;
    }

    public RaftProtocolConfig setRecoveryStrategy(Recovery recoveryStrategy) {
        this.recoveryStrategy = recoveryStrategy;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RaftProtocolConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public RaftProtocolConfig setRetryDelayMillis(long retryDelayMillis) {
        return this.setRetryDelay(Duration.ofMillis(retryDelayMillis));
    }

    public RaftProtocolConfig setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public RaftProtocolConfig setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }
}

