/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.collect.Maps;
import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.protocol.LocalRaftClientProtocol;
import io.atomix.protocols.raft.protocol.LocalRaftServerProtocol;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.utils.serializer.Serializer;
import java.util.Map;

public class LocalRaftProtocolFactory {
    private final Serializer serializer;
    private final Map<NodeId, LocalRaftServerProtocol> servers = Maps.newConcurrentMap();
    private final Map<NodeId, LocalRaftClientProtocol> clients = Maps.newConcurrentMap();

    public LocalRaftProtocolFactory(Serializer serializer) {
        this.serializer = serializer;
    }

    public RaftClientProtocol newClientProtocol(NodeId nodeId) {
        return new LocalRaftClientProtocol(nodeId, this.serializer, this.servers, this.clients);
    }

    public RaftServerProtocol newServerProtocol(NodeId nodeId) {
        return new LocalRaftServerProtocol(nodeId, this.serializer, this.servers, this.clients);
    }
}

