/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Collection;
import java.util.Objects;

public class HeartbeatRequest
extends AbstractRaftRequest {
    private final NodeId leader;
    private final Collection<NodeId> members;

    public static Builder builder() {
        return new Builder();
    }

    public HeartbeatRequest(NodeId leader, Collection<NodeId> members) {
        this.leader = leader;
        this.members = members;
    }

    public NodeId leader() {
        return this.leader;
    }

    public Collection<NodeId> members() {
        return this.members;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.leader, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof HeartbeatRequest) {
            HeartbeatRequest request = (HeartbeatRequest)object;
            return Objects.equals(request.leader, this.leader) && Objects.equals(request.members, this.members);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("leader", (Object)this.leader).add("members", this.members).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, HeartbeatRequest> {
        private NodeId leader;
        private Collection<NodeId> members;

        public Builder withLeader(NodeId leader) {
            this.leader = leader;
            return this;
        }

        public Builder withMembers(Collection<NodeId> members) {
            this.members = (Collection)Preconditions.checkNotNull(members, (Object)"members cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
        }

        public HeartbeatRequest build() {
            this.validate();
            return new HeartbeatRequest(this.leader, this.members);
        }
    }
}

