/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.cluster.RaftCluster;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.impl.DefaultRaftServer;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.utils.concurrent.ThreadModel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface RaftServer {
    public static Builder builder() {
        try {
            InetAddress address = InetAddress.getByName("0.0.0.0");
            return RaftServer.builder(NodeId.from((String)address.getHostName()));
        }
        catch (UnknownHostException e) {
            throw new RaftException.ConfigurationException("Cannot configure local node", new Object[]{e});
        }
    }

    public static Builder builder(NodeId localNodeId) {
        return new DefaultRaftServer.Builder(localNodeId);
    }

    public String name();

    public RaftCluster cluster();

    public Role getRole();

    default public boolean isLeader() {
        return this.getRole() == Role.LEADER;
    }

    default public boolean isFollower() {
        return this.getRole() == Role.FOLLOWER;
    }

    public void addRoleChangeListener(Consumer<Role> var1);

    public void removeRoleChangeListener(Consumer<Role> var1);

    default public CompletableFuture<RaftServer> bootstrap() {
        return this.bootstrap(Collections.emptyList());
    }

    default public CompletableFuture<RaftServer> bootstrap(NodeId ... members) {
        return this.bootstrap(Arrays.asList(members));
    }

    public CompletableFuture<RaftServer> bootstrap(Collection<NodeId> var1);

    default public CompletableFuture<RaftServer> join(NodeId ... members) {
        return this.join(Arrays.asList(members));
    }

    public CompletableFuture<RaftServer> join(Collection<NodeId> var1);

    default public CompletableFuture<RaftServer> listen(NodeId ... cluster) {
        return this.listen(Arrays.asList((Object[])Preconditions.checkNotNull((Object)cluster)));
    }

    public CompletableFuture<RaftServer> listen(Collection<NodeId> var1);

    public CompletableFuture<RaftServer> promote();

    public boolean isRunning();

    public CompletableFuture<Void> shutdown();

    public CompletableFuture<Void> leave();

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftServer> {
        private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(750L);
        private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
        private static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ofMillis(5000L);
        private static final ThreadModel DEFAULT_THREAD_MODEL = ThreadModel.SHARED_THREAD_POOL;
        private static final int DEFAULT_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
        protected String name;
        protected NodeId localNodeId;
        protected ClusterService clusterService;
        protected RaftServerProtocol protocol;
        protected RaftStorage storage;
        protected Duration electionTimeout = DEFAULT_ELECTION_TIMEOUT;
        protected Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
        protected Duration sessionTimeout = DEFAULT_SESSION_TIMEOUT;
        protected PrimitiveTypeRegistry primitiveTypes = new PrimitiveTypeRegistry();
        protected ThreadModel threadModel = DEFAULT_THREAD_MODEL;
        protected int threadPoolSize = DEFAULT_THREAD_POOL_SIZE;

        protected Builder(NodeId localNodeId) {
            this.localNodeId = (NodeId)Preconditions.checkNotNull((Object)localNodeId, (Object)"localNodeId cannot be null");
        }

        public Builder withName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
            return this;
        }

        public Builder withClusterService(ClusterService clusterService) {
            this.clusterService = (ClusterService)Preconditions.checkNotNull((Object)clusterService, (Object)"clusterService cannot be null");
            return this;
        }

        @Deprecated
        public Builder withType(RaftMember.Type type) {
            return this;
        }

        public Builder withProtocol(RaftServerProtocol protocol) {
            this.protocol = (RaftServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withStorage(RaftStorage storage) {
            this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
            return this;
        }

        public Builder withPrimitiveTypes(PrimitiveTypeRegistry primitiveTypes) {
            this.primitiveTypes = (PrimitiveTypeRegistry)Preconditions.checkNotNull((Object)primitiveTypes, (Object)"primitiveTypes cannot be null");
            return this;
        }

        public Builder addPrimitiveType(PrimitiveType primitiveType) {
            this.primitiveTypes.register(primitiveType);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            Preconditions.checkNotNull((Object)electionTimeout, (Object)"electionTimeout cannot be null");
            Preconditions.checkArgument((!electionTimeout.isNegative() && !electionTimeout.isZero() ? 1 : 0) != 0, (Object)"electionTimeout must be positive");
            Preconditions.checkArgument((electionTimeout.toMillis() > this.heartbeatInterval.toMillis() ? 1 : 0) != 0, (Object)"electionTimeout must be greater than heartbeatInterval");
            this.electionTimeout = electionTimeout;
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            Preconditions.checkNotNull((Object)heartbeatInterval, (Object)"heartbeatInterval cannot be null");
            Preconditions.checkArgument((!heartbeatInterval.isNegative() && !heartbeatInterval.isZero() ? 1 : 0) != 0, (Object)"sessionTimeout must be positive");
            Preconditions.checkArgument((heartbeatInterval.toMillis() < this.electionTimeout.toMillis() ? 1 : 0) != 0, (Object)"heartbeatInterval must be less than electionTimeout");
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            Preconditions.checkNotNull((Object)sessionTimeout, (Object)"sessionTimeout cannot be null");
            Preconditions.checkArgument((!sessionTimeout.isNegative() && !sessionTimeout.isZero() ? 1 : 0) != 0, (Object)"sessionTimeout must be positive");
            Preconditions.checkArgument((sessionTimeout.toMillis() > this.electionTimeout.toMillis() ? 1 : 0) != 0, (Object)"sessionTimeout must be greater than electionTimeout");
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }
    }

    public static enum Role {
        INACTIVE(false),
        PASSIVE(false),
        PROMOTABLE(false),
        FOLLOWER(true),
        CANDIDATE(true),
        LEADER(true);

        private final boolean active;

        private Role(boolean active) {
            this.active = active;
        }

        public boolean active() {
            return this.active;
        }
    }
}

