/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Collection;
import java.util.Objects;

public class HeartbeatRequest
extends AbstractRaftRequest {
    private final MemberId leader;
    private final Collection<MemberId> members;

    public static Builder newBuilder() {
        return new Builder();
    }

    public HeartbeatRequest(MemberId leader, Collection<MemberId> members) {
        this.leader = leader;
        this.members = members;
    }

    public MemberId leader() {
        return this.leader;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.leader, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof HeartbeatRequest) {
            HeartbeatRequest request = (HeartbeatRequest)object;
            return Objects.equals(request.leader, this.leader) && Objects.equals(request.members, this.members);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("leader", (Object)this.leader).add("members", this.members).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, HeartbeatRequest> {
        private MemberId leader;
        private Collection<MemberId> members;

        public Builder withLeader(MemberId leader) {
            this.leader = leader;
            return this;
        }

        public Builder withMembers(Collection<MemberId> members) {
            this.members = (Collection)Preconditions.checkNotNull(members, (Object)"members cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
        }

        public HeartbeatRequest build() {
            this.validate();
            return new HeartbeatRequest(this.leader, this.members);
        }
    }
}

