/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.MappableJournalSegmentWriter;
import io.atomix.storage.journal.SegmentedJournal;
import java.nio.BufferOverflowException;

public class SegmentedJournalWriter<E>
implements JournalWriter<E> {
    private final SegmentedJournal<E> journal;
    private JournalSegment<E> currentSegment;
    private MappableJournalSegmentWriter<E> currentWriter;

    public SegmentedJournalWriter(SegmentedJournal<E> journal) {
        this.journal = journal;
        this.currentSegment = journal.getLastSegment();
        this.currentSegment.acquire();
        this.currentWriter = this.currentSegment.writer();
    }

    @Override
    public long getLastIndex() {
        return this.currentWriter.getLastIndex();
    }

    @Override
    public Indexed<E> getLastEntry() {
        return this.currentWriter.getLastEntry();
    }

    @Override
    public long getNextIndex() {
        return this.currentWriter.getNextIndex();
    }

    @Override
    public void reset(long index) {
        if (index > this.currentSegment.index()) {
            this.currentWriter.close();
            this.currentSegment.release();
            this.currentSegment = this.journal.resetSegments(index);
            this.currentSegment.acquire();
            this.currentWriter = this.currentSegment.writer();
        } else {
            this.truncate(index - 1L);
        }
        this.journal.resetHead(index);
    }

    @Override
    public void commit(long index) {
        if (index > this.journal.getCommitIndex()) {
            this.journal.setCommitIndex(index);
            if (this.journal.isFlushOnCommit()) {
                this.flush();
            }
        }
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        try {
            return this.currentWriter.append(entry);
        }
        catch (BufferOverflowException e) {
            if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
                throw e;
            }
            this.currentWriter.flush();
            this.currentSegment.release();
            this.currentSegment = this.journal.getNextSegment();
            this.currentSegment.acquire();
            this.currentWriter = this.currentSegment.writer();
            return this.currentWriter.append(entry);
        }
    }

    @Override
    public void append(Indexed<E> entry) {
        try {
            this.currentWriter.append(entry);
        }
        catch (BufferOverflowException e) {
            if (this.currentSegment.index() == this.currentWriter.getNextIndex()) {
                throw e;
            }
            this.currentWriter.flush();
            this.currentSegment.release();
            this.currentSegment = this.journal.getNextSegment();
            this.currentSegment.acquire();
            this.currentWriter = this.currentSegment.writer();
            this.currentWriter.append(entry);
        }
    }

    @Override
    public void truncate(long index) {
        if (index < this.journal.getCommitIndex()) {
            throw new IndexOutOfBoundsException("Cannot truncate committed index: " + index);
        }
        while (index < this.currentSegment.index() && this.currentSegment != this.journal.getFirstSegment()) {
            this.currentSegment.release();
            this.journal.removeSegment(this.currentSegment);
            this.currentSegment = this.journal.getLastSegment();
            this.currentSegment.acquire();
            this.currentWriter = this.currentSegment.writer();
        }
        this.currentWriter.truncate(index);
        this.journal.resetTail(index + 1L);
    }

    @Override
    public void flush() {
        this.currentWriter.flush();
    }

    @Override
    public void close() {
        this.currentWriter.close();
    }
}

