/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.ByteBufferBytes;
import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.FileBytes;
import io.atomix.utils.AtomixIOException;
import io.atomix.utils.memory.BufferCleaner;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedBytes
extends ByteBufferBytes {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedBytes.class);
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel.MapMode mode;

    public static MappedBytes allocate(File file, int size) {
        return MappedBytes.allocate(file, FileChannel.MapMode.READ_WRITE, size);
    }

    public static MappedBytes allocate(File file, FileChannel.MapMode mode, int size) {
        return FileBytes.allocate(file, size).map(0, size, mode);
    }

    protected MappedBytes(File file, RandomAccessFile randomAccessFile, MappedByteBuffer buffer, FileChannel.MapMode mode) {
        super(buffer);
        this.file = file;
        this.randomAccessFile = randomAccessFile;
        this.mode = mode;
    }

    @Override
    protected ByteBuffer newByteBuffer(int size) {
        try {
            return this.randomAccessFile.getChannel().map(this.mode, 0L, size);
        }
        catch (IOException e) {
            throw new AtomixIOException((Throwable)e);
        }
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public Bytes flush() {
        ((MappedByteBuffer)this.buffer).force();
        return this;
    }

    @Override
    public void close() {
        block4: {
            try {
                BufferCleaner.freeBuffer((ByteBuffer)this.buffer);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("Failed to unmap direct buffer", (Throwable)e);
            }
        }
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.close();
    }

    public void delete() {
        try {
            this.close();
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parseMode(FileChannel.MapMode mode) {
        if (mode == FileChannel.MapMode.READ_ONLY) {
            return "r";
        }
        if (mode == FileChannel.MapMode.READ_WRITE) {
            return "rw";
        }
        throw new IllegalArgumentException("unsupported map mode");
    }
}

