/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal.index;

import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import java.util.Map;
import java.util.TreeMap;

public class SparseJournalIndex
implements JournalIndex {
    private static final int MIN_DENSITY = 1000;
    private final int density;
    private final TreeMap<Long, Integer> positions = new TreeMap();

    public SparseJournalIndex(double density) {
        this.density = (int)Math.ceil(1000.0 / (density * 1000.0));
    }

    @Override
    public void index(long index, int position) {
        if (index % (long)this.density == 0L) {
            this.positions.put(index, position);
        }
    }

    @Override
    public Position lookup(long index) {
        Map.Entry<Long, Integer> entry = this.positions.floorEntry(index);
        return entry != null ? new Position(entry.getKey(), entry.getValue()) : null;
    }

    @Override
    public void truncate(long index) {
        this.positions.tailMap(index, false).clear();
    }
}

