/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.storage.journal.JournalSegmentCache;
import io.atomix.storage.journal.JournalSegmentDescriptor;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.JournalSegmentReader;
import io.atomix.storage.journal.JournalSegmentWriter;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.SparseJournalIndex;
import io.atomix.utils.serializer.Serializer;

public class JournalSegment<E>
implements AutoCloseable {
    protected final JournalSegmentFile file;
    protected final JournalSegmentDescriptor descriptor;
    private final int maxEntrySize;
    protected final JournalIndex index;
    protected final Serializer serializer;
    private final JournalSegmentWriter<E> writer;
    private final JournalSegmentCache cache;
    private boolean open = true;

    public JournalSegment(JournalSegmentFile file, JournalSegmentDescriptor descriptor, int maxEntrySize, double indexDensity, int cacheSize, Serializer serializer) {
        this.file = file;
        this.descriptor = descriptor;
        this.maxEntrySize = maxEntrySize;
        this.index = new SparseJournalIndex(indexDensity);
        this.serializer = serializer;
        this.cache = new JournalSegmentCache(descriptor.index(), cacheSize);
        this.writer = new JournalSegmentWriter(descriptor, maxEntrySize, this.cache, this.index, serializer);
    }

    public long id() {
        return this.descriptor.id();
    }

    public long version() {
        return this.descriptor.version();
    }

    public long index() {
        return this.descriptor.index();
    }

    public long lastIndex() {
        return this.writer.getLastIndex();
    }

    public JournalSegmentFile file() {
        return this.file;
    }

    public JournalSegmentDescriptor descriptor() {
        return this.descriptor;
    }

    public long size() {
        return this.writer.size();
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public boolean isFull() {
        return this.writer.isFull();
    }

    public long length() {
        return this.writer.getNextIndex() - this.index();
    }

    public JournalSegmentWriter<E> writer() {
        this.checkOpen();
        return this.writer;
    }

    JournalSegmentReader<E> createReader() {
        this.checkOpen();
        return new JournalSegmentReader(this.descriptor, this.maxEntrySize, this.cache, this.index, this.serializer);
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Segment not open");
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.writer.close();
        this.descriptor.close();
        this.open = false;
    }

    public void delete() {
        this.writer.delete();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("version", this.version()).add("index", this.index()).add("size", this.size()).toString();
    }
}

