/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.queue.AsyncWorkQueue;
import io.atomix.rest.utils.EventLog;
import io.atomix.rest.utils.EventManager;
import java.util.function.Consumer;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkQueueResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkQueueResource.class);
    private final AsyncWorkQueue<String> workQueue;

    public WorkQueueResource(AsyncWorkQueue<String> workQueue) {
        this.workQueue = workQueue;
    }

    @POST
    @Consumes(value={"text/plain"})
    public void add(String item, @Suspended AsyncResponse response) {
        this.workQueue.addOne((Object)item).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Produces(value={"application/json"})
    public void take(@Context EventManager events, @Suspended AsyncResponse response) {
        EventLog<Consumer<String>, String> eventLog = events.getOrCreateEventLog(AsyncWorkQueue.class, this.workQueue.name(), l -> e -> l.addEvent(e));
        if (eventLog.open()) {
            this.workQueue.registerTaskProcessor(eventLog.listener(), 1, MoreExecutors.directExecutor()).whenComplete((result, error) -> {
                if (error == null) {
                    this.takeTask(eventLog, response);
                } else {
                    LOGGER.warn("{}", error);
                    response.resume((Object)Response.serverError().build());
                }
            });
        } else {
            this.takeTask(eventLog, response);
        }
    }

    private void takeTask(EventLog<Consumer<String>, String> eventLog, AsyncResponse response) {
        eventLog.nextEvent().whenComplete((eventResult, eventError) -> {
            if (eventError == null) {
                response.resume((Object)Response.ok((Object)eventResult).build());
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
        });
    }
}

