/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.collect.Maps;
import io.atomix.core.tree.AsyncDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.IllegalDocumentModificationException;
import io.atomix.core.tree.NoSuchDocumentPathException;
import io.atomix.utils.time.Versioned;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTreeResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentTreeResource.class);
    private final AsyncDocumentTree<String> documentTree;

    public DocumentTreeResource(AsyncDocumentTree<String> documentTree) {
        this.documentTree = documentTree;
    }

    private DocumentPath getDocumentPath(List<PathSegment> params) {
        if (params.isEmpty()) {
            return this.documentTree.root();
        }
        ArrayList path = new ArrayList(this.documentTree.root().pathElements());
        path.addAll(params.stream().map(PathSegment::getPath).collect(Collectors.toList()));
        return DocumentPath.from(path);
    }

    @GET
    @Path(value="/{path: .*}")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="path") List<PathSegment> path, @Suspended AsyncResponse response) {
        this.documentTree.get(this.getDocumentPath(path)).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new VersionedResult((Versioned<String>)result)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{path: .*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void create(@PathParam(value="path") List<PathSegment> path, String value, @Suspended AsyncResponse response) {
        this.documentTree.createRecursive(this.getDocumentPath(path), (Object)value).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{path: .*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void set(@PathParam(value="path") List<PathSegment> path, String value, @QueryParam(value="version") Long version, @Suspended AsyncResponse response) {
        CompletionStage future = version != null ? this.documentTree.replace(this.getDocumentPath(path), (Object)value, version.longValue()) : this.documentTree.set(this.getDocumentPath(path), (Object)value).thenApply(v -> Boolean.TRUE);
        ((CompletableFuture)future).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                if (error.getCause() != null) {
                    error = error.getCause();
                }
                if (error instanceof IllegalDocumentModificationException || error instanceof NoSuchDocumentPathException) {
                    response.resume((Object)Response.ok((Object)false).build());
                } else {
                    LOGGER.warn("{}", error);
                    response.resume((Object)Response.serverError().build());
                }
            }
        });
    }

    @GET
    @Path(value="/children")
    @Produces(value={"application/json"})
    public void getRootChildren(@Suspended AsyncResponse response) {
        this.documentTree.getChildren(this.documentTree.root()).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)Maps.transformValues((Map)result, VersionedResult::new)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/children/{path: .*}")
    @Produces(value={"application/json"})
    public void getChildren(@PathParam(value="path") List<PathSegment> path, @Suspended AsyncResponse response) {
        this.documentTree.getChildren(this.getDocumentPath(path)).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)Maps.transformValues((Map)result, VersionedResult::new)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{path: .*}")
    @Produces(value={"application/json"})
    public void removeNode(@PathParam(value="path") List<PathSegment> path, @Suspended AsyncResponse response) {
        this.documentTree.removeNode(this.getDocumentPath(path)).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new VersionedResult((Versioned<String>)result)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class VersionedResult {
        private final Versioned<String> value;

        public VersionedResult(Versioned<String> value) {
            this.value = value;
        }

        public String getValue() {
            return (String)this.value.value();
        }

        public long getVersion() {
            return this.value.version();
        }
    }
}

