/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.cluster.ClusterEvent;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.rest.resources.AbstractRestResource;
import io.atomix.rest.utils.EventLog;
import io.atomix.rest.utils.EventManager;
import io.atomix.utils.event.EventListener;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/cluster")
public class ClusterResource
extends AbstractRestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterResource.class);

    @GET
    @Path(value="/node")
    @Produces(value={"application/json"})
    public Response getNode(@Context ClusterService clusterService) {
        return Response.ok((Object)new NodeInfo(clusterService.getLocalNode())).build();
    }

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json"})
    public Response getNodes(@Context ClusterService clusterService) {
        return Response.ok(clusterService.getNodes().stream().map(NodeInfo::new).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/nodes/{node}")
    @Produces(value={"application/json"})
    public Response getNodeInfo(@PathParam(value="node") String nodeId, @Context ClusterService clusterService) {
        Node node = clusterService.getNode(NodeId.from((String)nodeId));
        if (node == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new NodeInfo(node)).build();
    }

    @GET
    @Path(value="/events")
    @Produces(value={"application/json"})
    public void getEvent(@Context ClusterService clusterService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, "", l -> e -> l.addEvent(e));
        if (eventLog.open()) {
            clusterService.addListener((EventListener)eventLog.listener());
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Node)result.subject()).id(), (ClusterEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/events")
    @Produces(value={"application/json"})
    public Response addListener(@Context ClusterService clusterService, @Context EventManager events) {
        String listenerId = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, listenerId, l -> e -> l.addEvent(e));
        if (eventLog.open()) {
            clusterService.addListener((EventListener)eventLog.listener());
        }
        return Response.ok((Object)listenerId).build();
    }

    @GET
    @Path(value="/events/{id}")
    @Produces(value={"application/json"})
    public void getEvent(@PathParam(value="id") String listenerId, @Context ClusterService clusterService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getEventLog(ClusterResource.class, listenerId);
        if (eventLog == null) {
            response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Node)result.subject()).id(), (ClusterEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/events/{id}")
    public void removeListener(@PathParam(value="id") String listenerId, @Context ClusterService clusterService, @Context EventManager events) {
        EventLog eventLog = events.removeEventLog(ClusterResource.class, listenerId);
        if (eventLog != null && eventLog.close()) {
            clusterService.removeListener((EventListener)eventLog.listener());
        }
    }

    @GET
    @Path(value="/nodes/{node}/events")
    @Produces(value={"application/json"})
    public void getNodeEvent(@PathParam(value="node") String nodeId, @Context ClusterService clusterService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, nodeId, l -> e -> {
            if (((String)((Object)((Node)e.subject()).id().id())).equals(nodeId)) {
                l.addEvent(e);
            }
        });
        if (eventLog.open()) {
            clusterService.addListener((EventListener)eventLog.listener());
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Node)result.subject()).id(), (ClusterEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/nodes/{node}/events")
    @Produces(value={"application/json"})
    public Response addNodeListener(@PathParam(value="node") String nodeId, @Context ClusterService clusterService, @Context EventManager events) {
        String id = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(ClusterResource.class, ClusterResource.getNodeListener(nodeId, id), l -> e -> {
            if (((String)((Object)((Node)e.subject()).id().id())).equals(nodeId)) {
                l.addEvent(e);
            }
        });
        if (eventLog.open()) {
            clusterService.addListener((EventListener)eventLog.listener());
        }
        return Response.ok((Object)id).build();
    }

    @GET
    @Path(value="/nodes/{node}/events/{id}")
    @Produces(value={"application/json"})
    public void getNodeEvent(@PathParam(value="node") String nodeId, @PathParam(value="id") String listenerId, @Context ClusterService clusterService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getEventLog(ClusterResource.class, ClusterResource.getNodeListener(nodeId, listenerId));
        if (eventLog == null) {
            response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        eventLog.nextEvent().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new NodeEvent(((Node)result.subject()).id(), (ClusterEvent.Type)result.type())));
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/nodes/{node}/events/{id}")
    public void removeNodeListener(@PathParam(value="node") String nodeId, @PathParam(value="id") String listenerId, @Context ClusterService clusterService, @Context EventManager events) {
        EventLog eventLog = events.removeEventLog(ClusterResource.class, ClusterResource.getNodeListener(nodeId, listenerId));
        if (eventLog != null && eventLog.close()) {
            clusterService.removeListener((EventListener)eventLog.listener());
        }
    }

    private static String getNodeListener(String nodeId, String id) {
        return String.format("%s-%s", nodeId, id);
    }

    static class NodeEvent {
        private final NodeId nodeId;
        private final ClusterEvent.Type type;

        public NodeEvent(NodeId nodeId, ClusterEvent.Type type) {
            this.nodeId = nodeId;
            this.type = type;
        }

        public String getId() {
            return (String)((Object)this.nodeId.id());
        }

        public ClusterEvent.Type getType() {
            return this.type;
        }
    }

    static class NodeInfo {
        private final Node node;

        NodeInfo(Node node) {
            this.node = node;
        }

        public String getId() {
            return (String)((Object)this.node.id().id());
        }

        public String getHost() {
            return this.node.endpoint().host().getHostAddress();
        }

        public int getPort() {
            return this.node.endpoint().port();
        }

        public Node.Type getType() {
            return this.node.type();
        }

        public Node.State getStatus() {
            return this.node.getState();
        }
    }
}

