/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service.impl;

import io.atomix.primitive.service.BackupInput;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.BufferInput;
import io.atomix.storage.buffer.Bytes;
import io.atomix.utils.serializer.Serializer;
import java.nio.charset.Charset;

public class DefaultBackupInput
implements BackupInput {
    private final BufferInput<?> input;
    private final Serializer serializer;

    public DefaultBackupInput(BufferInput<?> input, Serializer serializer) {
        this.input = input;
        this.serializer = serializer;
    }

    @Override
    public <U> U readObject() {
        return (U)this.input.readObject(bytes -> bytes != null ? this.serializer.decode(bytes) : null);
    }

    public int position() {
        return this.input.position();
    }

    public int remaining() {
        return this.input.remaining();
    }

    public boolean hasRemaining() {
        return this.input.hasRemaining();
    }

    public BackupInput skip(int bytes) {
        this.input.skip(bytes);
        return this;
    }

    public BackupInput read(Bytes bytes) {
        this.input.read(bytes);
        return this;
    }

    public BackupInput read(byte[] bytes) {
        this.input.read(bytes);
        return this;
    }

    public BackupInput read(Bytes bytes, int offset, int length) {
        this.input.read(bytes, offset, length);
        return this;
    }

    public BackupInput read(byte[] bytes, int offset, int length) {
        this.input.read(bytes, offset, length);
        return this;
    }

    public BackupInput read(Buffer buffer) {
        this.input.read(buffer);
        return this;
    }

    public int readByte() {
        return this.input.readByte();
    }

    public int readUnsignedByte() {
        return this.input.readUnsignedByte();
    }

    public char readChar() {
        return this.input.readChar();
    }

    public short readShort() {
        return this.input.readShort();
    }

    public int readUnsignedShort() {
        return this.input.readUnsignedShort();
    }

    public int readMedium() {
        return this.input.readMedium();
    }

    public int readUnsignedMedium() {
        return this.input.readUnsignedMedium();
    }

    public int readInt() {
        return this.input.readInt();
    }

    public long readUnsignedInt() {
        return this.input.readUnsignedInt();
    }

    public long readLong() {
        return this.input.readLong();
    }

    public float readFloat() {
        return this.input.readFloat();
    }

    public double readDouble() {
        return this.input.readDouble();
    }

    public boolean readBoolean() {
        return this.input.readBoolean();
    }

    public String readString() {
        return this.input.readString();
    }

    public String readString(Charset charset) {
        return this.input.readString(charset);
    }

    public String readUTF8() {
        return this.input.readUTF8();
    }

    public void close() {
        this.input.close();
    }
}

