/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service.impl;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.session.Session;
import io.atomix.utils.misc.ArraySizeHashPrinter;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.Objects;
import java.util.function.Function;

public class DefaultCommit<T>
implements Commit<T> {
    private final long index;
    private final Session session;
    private final long timestamp;
    private final OperationId operation;
    private final T value;

    public DefaultCommit(long index, OperationId operation, T value, Session session, long timestamp) {
        this.index = index;
        this.session = session;
        this.timestamp = timestamp;
        this.operation = operation;
        this.value = value;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public LogicalTimestamp logicalTime() {
        return LogicalTimestamp.of((long)this.index);
    }

    @Override
    public WallClockTimestamp wallClockTime() {
        return WallClockTimestamp.from((long)this.timestamp);
    }

    @Override
    public OperationId operation() {
        return this.operation;
    }

    @Override
    public T value() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Commit.class, this.index, this.session.sessionId(), this.operation});
    }

    @Override
    public <U> Commit<U> map(Function<T, U> transcoder) {
        return new DefaultCommit<U>(this.index, this.operation, transcoder.apply(this.value), this.session, this.timestamp);
    }

    @Override
    public Commit<Void> mapToNull() {
        return new DefaultCommit<Object>(this.index, this.operation, null, this.session, this.timestamp);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Commit) {
            Commit commit = (Commit)object;
            return commit.index() == this.index && commit.session().equals(this.session) && commit.operation().equals(this.operation) && Objects.equals(commit.value(), this.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("session", (Object)this.session).add("time", (Object)this.wallClockTime()).add("operation", (Object)this.operation).add("value", this.value instanceof byte[] ? ArraySizeHashPrinter.of((byte[])((byte[])this.value)) : this.value).toString();
    }
}

