/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.partition.GroupMember;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PrimaryTerm {
    private final long term;
    private final GroupMember primary;
    private final List<GroupMember> candidates;

    public PrimaryTerm(long term, GroupMember primary, List<GroupMember> candidates) {
        this.term = term;
        this.primary = primary;
        this.candidates = candidates;
    }

    public long term() {
        return this.term;
    }

    public GroupMember primary() {
        return this.primary;
    }

    public List<GroupMember> candidates() {
        return this.candidates;
    }

    public List<GroupMember> backups(int numBackups) {
        if (this.primary == null || this.candidates.isEmpty()) {
            return Collections.emptyList();
        }
        return this.candidates.subList(1, Math.min(this.candidates.size(), numBackups + 1));
    }

    public int hashCode() {
        return Objects.hash(this.term, this.primary, this.candidates);
    }

    public boolean equals(Object object) {
        if (object instanceof PrimaryTerm) {
            PrimaryTerm term = (PrimaryTerm)object;
            return term.term == this.term && Objects.equals(term.primary, this.primary) && Objects.equals(term.candidates, this.candidates);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("primary", (Object)this.primary).add("candidates", this.candidates).toString();
    }
}

