/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.operation;

import io.atomix.primitive.operation.Command;
import io.atomix.primitive.operation.Operation;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.operation.Query;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class Operations {
    public static Map<Method, OperationId> getMethodMap(Class<?> serviceInterface) {
        if (!serviceInterface.isInterface()) {
            HashMap<Method, OperationId> operations = new HashMap<Method, OperationId>();
            for (Class<?> iface : serviceInterface.getInterfaces()) {
                operations.putAll(Operations.findMethods(iface));
            }
            return operations;
        }
        return Operations.findMethods(serviceInterface);
    }

    private static Map<Method, OperationId> findMethods(Class<?> type) {
        HashMap<Method, OperationId> operations = new HashMap<Method, OperationId>();
        for (Method method : type.getDeclaredMethods()) {
            OperationId operationId = Operations.getOperationId(method);
            if (operationId == null) continue;
            if (operations.values().stream().anyMatch(operation -> ((String)((Object)operation.id())).equals(operationId.id()))) {
                throw new IllegalStateException("Duplicate operation name '" + (String)((Object)operationId.id()) + "'");
            }
            operations.put(method, operationId);
        }
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            operations.putAll(Operations.findMethods(genericDeclaration));
        }
        return operations;
    }

    public static Map<OperationId, Method> getOperationMap(Class<?> serviceInterface) {
        if (!serviceInterface.isInterface()) {
            HashMap<OperationId, Method> operations = new HashMap<OperationId, Method>();
            for (Class<?> type = serviceInterface; type != Object.class; type = type.getSuperclass()) {
                for (Class<?> iface : type.getInterfaces()) {
                    operations.putAll(Operations.findOperations(iface));
                }
            }
            return operations;
        }
        return Operations.findOperations(serviceInterface);
    }

    private static Map<OperationId, Method> findOperations(Class<?> type) {
        HashMap<OperationId, Method> operations = new HashMap<OperationId, Method>();
        for (Method method : type.getDeclaredMethods()) {
            OperationId operationId = Operations.getOperationId(method);
            if (operationId == null) continue;
            if (operations.keySet().stream().anyMatch(operation -> ((String)((Object)operation.id())).equals(operationId.id()))) {
                throw new IllegalStateException("Duplicate operation name '" + (String)((Object)operationId.id()) + "'");
            }
            operations.put(operationId, method);
        }
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            operations.putAll(Operations.findOperations(genericDeclaration));
        }
        return operations;
    }

    private static OperationId getOperationId(Method method) {
        Command command = method.getAnnotation(Command.class);
        if (command != null) {
            String name = "".equals(command.value()) ? method.getName() : command.value();
            return OperationId.from(name, OperationType.COMMAND);
        }
        Query query = method.getAnnotation(Query.class);
        if (query != null) {
            String name = "".equals(query.value()) ? method.getName() : query.value();
            return OperationId.from(name, OperationType.QUERY);
        }
        Operation operation = method.getAnnotation(Operation.class);
        if (operation != null) {
            String name = "".equals(operation.value()) ? method.getName() : operation.value();
            return OperationId.from(name, operation.type());
        }
        return null;
    }

    private Operations() {
    }
}

