/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.Defaults;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.Events;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.Operations;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.proxy.ProxySession;
import io.atomix.primitive.session.SessionClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.serializer.Serializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxySession<S>
implements ProxySession<S> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SessionClient session;
    private final Serializer serializer;
    private final ServiceProxy<S> proxy;
    private volatile CompletableFuture<ProxySession<S>> connectFuture;
    private volatile boolean closed;

    public DefaultProxySession(SessionClient session, Class<S> serviceType, Serializer serializer) {
        this.session = session;
        this.serializer = serializer;
        ServiceProxyHandler serviceProxyHandler = new ServiceProxyHandler(serviceType);
        Object serviceProxy = Proxy.newProxyInstance(serviceType.getClassLoader(), new Class[]{serviceType}, (InvocationHandler)serviceProxyHandler);
        this.proxy = new ServiceProxy<Object>(serviceProxy, serviceProxyHandler);
    }

    @Override
    public String name() {
        return this.session.name();
    }

    @Override
    public PrimitiveType type() {
        return this.session.type();
    }

    @Override
    public PartitionId partitionId() {
        return this.session.partitionId();
    }

    @Override
    public ThreadContext context() {
        return this.session.context();
    }

    @Override
    public PrimitiveState getState() {
        return this.session.getState();
    }

    @Override
    public void register(Object client) {
        Events.getEventMap(client.getClass()).forEach((eventType, method) -> this.session.addEventListener((EventType)eventType, event -> {
            try {
                method.invoke(client, (Object[])this.decode(event.value()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log.warn("Failed to handle event", (Throwable)e);
            }
        }));
    }

    @Override
    public CompletableFuture<Void> accept(Consumer<S> operation) {
        if (this.closed) {
            return Futures.exceptionalFuture((Throwable)((Object)new PrimitiveException.ClosedSession()));
        }
        return this.proxy.accept(operation);
    }

    @Override
    public <R> CompletableFuture<R> apply(Function<S, R> operation) {
        if (this.closed) {
            return Futures.exceptionalFuture((Throwable)((Object)new PrimitiveException.ClosedSession()));
        }
        return this.proxy.apply(operation);
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.session.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.session.removeStateChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ProxySession<S>> connect() {
        if (this.connectFuture == null) {
            DefaultProxySession defaultProxySession = this;
            synchronized (defaultProxySession) {
                if (this.connectFuture == null) {
                    this.connectFuture = this.session.connect().thenApply(v -> this);
                }
            }
        }
        return this.connectFuture;
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.session.close().thenRun(() -> {
            this.closed = true;
        });
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.session.delete().thenRun(() -> {
            this.closed = true;
        });
    }

    protected Serializer serializer() {
        return this.serializer;
    }

    protected <T> byte[] encode(T object) {
        return object != null ? this.serializer().encode(object) : null;
    }

    protected <T> T decode(byte[] bytes) {
        return (T)(bytes != null ? this.serializer().decode(bytes) : null);
    }

    private class ServiceProxyHandler
    implements InvocationHandler {
        private final ThreadLocal<CompletableFuture> future = new ThreadLocal();
        private final Map<Method, OperationId> operations = new ConcurrentHashMap<Method, OperationId>();

        private ServiceProxyHandler(Class<?> type) {
            this.operations.putAll(Operations.getMethodMap(type));
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            OperationId operationId = this.operations.get(method);
            if (operationId == null) {
                throw new PrimitiveException("Unknown primitive operation: " + method.getName());
            }
            this.future.set((CompletableFuture)DefaultProxySession.this.session.execute(PrimitiveOperation.operation(operationId, DefaultProxySession.this.encode(args))).thenApply(DefaultProxySession.this::decode));
            return Defaults.defaultValue(method.getReturnType());
        }

        <T> CompletableFuture<T> getResultFuture() {
            return this.future.get();
        }
    }

    private class ServiceProxy<S> {
        private final S proxy;
        private final ServiceProxyHandler handler;

        ServiceProxy(S proxy, ServiceProxyHandler handler) {
            this.proxy = proxy;
            this.handler = handler;
        }

        CompletableFuture<Void> accept(Consumer<S> operation) {
            operation.accept(this.proxy);
            return this.handler.getResultFuture();
        }

        <T> CompletableFuture<T> apply(Function<S, T> operation) {
            operation.apply(this.proxy);
            return this.handler.getResultFuture();
        }
    }
}

