/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.ManagedPrimaryElectionService;
import io.atomix.primitive.partition.PartitionGroupMembershipService;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEvent;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryElectionService;
import io.atomix.primitive.partition.impl.HashBasedPrimaryElection;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashBasedPrimaryElectionService
extends AbstractListenerManager<PrimaryElectionEvent, PrimaryElectionEventListener>
implements ManagedPrimaryElectionService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClusterMembershipService clusterMembershipService;
    private final PartitionGroupMembershipService groupMembershipService;
    private final ClusterCommunicationService messagingService;
    private final Map<PartitionId, HashBasedPrimaryElection> elections = Maps.newConcurrentMap();
    private final PrimaryElectionEventListener primaryElectionListener = arg_0 -> ((HashBasedPrimaryElectionService)this).post(arg_0);
    private final ScheduledExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean();

    public HashBasedPrimaryElectionService(ClusterMembershipService clusterMembershipService, PartitionGroupMembershipService groupMembershipService, ClusterCommunicationService messagingService) {
        this.clusterMembershipService = clusterMembershipService;
        this.groupMembershipService = groupMembershipService;
        this.messagingService = messagingService;
        this.executor = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"primary-election-%d", (Logger)this.log));
    }

    @Override
    public PrimaryElection getElectionFor(PartitionId partitionId) {
        return this.elections.computeIfAbsent(partitionId, id -> {
            HashBasedPrimaryElection election = new HashBasedPrimaryElection(partitionId, this.clusterMembershipService, this.groupMembershipService, this.messagingService, this.executor);
            election.addListener(this.primaryElectionListener);
            return election;
        });
    }

    public CompletableFuture<PrimaryElectionService> start() {
        this.started.set(true);
        this.log.info("Started");
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.elections.values().forEach(election -> election.close());
        }
        this.executor.shutdownNow();
        return CompletableFuture.completedFuture(null);
    }
}

