/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.ManagedSessionIdService;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.primitive.session.SessionIdService;
import io.atomix.primitive.session.impl.SessionIdGeneratorOperations;
import io.atomix.primitive.session.impl.SessionIdGeneratorType;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReplicatedSessionIdService
implements ManagedSessionIdService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(SessionIdGeneratorOperations.NAMESPACE).build());
    private static final String PRIMITIVE_NAME = "session-id";
    private final PartitionGroup systemPartitionGroup;
    private SessionClient proxy;
    private final AtomicBoolean started = new AtomicBoolean();

    public ReplicatedSessionIdService(PartitionGroup systemPartitionGroup) {
        this.systemPartitionGroup = systemPartitionGroup;
    }

    @Override
    public CompletableFuture<SessionId> nextSessionId() {
        return ((CompletableFuture)this.proxy.execute(PrimitiveOperation.operation(SessionIdGeneratorOperations.NEXT)).thenApply(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0))).thenApply(SessionId::from);
    }

    public CompletableFuture<SessionIdService> start() {
        return ((SessionClient)this.systemPartitionGroup.getPartitions().iterator().next().getClient().sessionBuilder(PRIMITIVE_NAME, SessionIdGeneratorType.instance(), new ServiceConfig()).build()).connect().thenApply(proxy -> {
            this.proxy = proxy;
            this.started.set(true);
            return this;
        });
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        return ((CompletableFuture)this.proxy.close().exceptionally(v -> null)).thenRun(() -> this.started.set(false));
    }
}

