/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.impl;

import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.utils.ServiceException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultPrimitiveTypeRegistry
implements PrimitiveTypeRegistry {
    private final Map<String, PrimitiveType> primitiveTypes = new ConcurrentHashMap<String, PrimitiveType>();

    public DefaultPrimitiveTypeRegistry(Collection<PrimitiveType> primitiveTypes) {
        primitiveTypes.forEach(type -> this.primitiveTypes.put(type.name(), (PrimitiveType)type));
    }

    @Override
    public Collection<PrimitiveType> getPrimitiveTypes() {
        return this.primitiveTypes.values();
    }

    @Override
    public PrimitiveType getPrimitiveType(String typeName) {
        PrimitiveType type = this.primitiveTypes.get(typeName);
        if (type == null) {
            throw new ServiceException("Unknown primitive type " + typeName);
        }
        return type;
    }
}

