/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.config.impl;

import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.config.ConfigService;
import io.atomix.primitive.config.PrimitiveConfig;
import java.util.Collection;
import java.util.Map;

public class DefaultConfigService
implements ConfigService {
    private final Map<String, PrimitiveConfig> defaultConfigs = Maps.newConcurrentMap();
    private final Map<String, PrimitiveConfig> configs = Maps.newConcurrentMap();

    public DefaultConfigService(Collection<PrimitiveConfig> defaultConfigs, Collection<PrimitiveConfig> configs) {
        defaultConfigs.forEach(config -> this.defaultConfigs.put(((PrimitiveType)config.getType()).name(), (PrimitiveConfig)config));
        configs.forEach(config -> this.configs.put(config.getName(), (PrimitiveConfig)config));
    }

    @Override
    public <C extends PrimitiveConfig<C>> C getConfig(String primitiveName, PrimitiveType primitiveType) {
        PrimitiveConfig config = this.configs.get(primitiveName);
        if (config != null) {
            return (C)config;
        }
        if (primitiveType == null) {
            return null;
        }
        config = this.defaultConfigs.get(primitiveType.name());
        if (config != null) {
            return (C)config;
        }
        return (C)primitiveType.newConfig();
    }
}

