/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.AtomixRuntimeException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class Synchronous<T extends AsyncPrimitive>
implements SyncPrimitive {
    private final T primitive;

    public Synchronous(T primitive) {
        this.primitive = primitive;
    }

    @Override
    public String name() {
        return this.primitive.name();
    }

    @Override
    public PrimitiveType type() {
        return this.primitive.type();
    }

    @Override
    public PrimitiveProtocol protocol() {
        return this.primitive.protocol();
    }

    @Override
    public void delete() {
        try {
            this.primitive.delete().get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AtomixRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.primitive.close().get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AtomixRuntimeException((Throwable)e);
        }
    }
}

